package gov.va.cpss.job.apps;

import static gov.va.cpss.job.CbssJobProcessingConstants.WRITE_FAILURE_STATUS;
import static gov.va.cpss.model.ps.Constants.LINE_FEED;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSSite;

import gov.va.cpss.job.CBSSBaseMultiItemWriter;

import gov.va.cpss.service.LoadAPPSService;

/**
 * 
 * Implementation of ItemWriter used to handle writing of raw records when
 * loading and processing APPS data.
 * 
 * Copyright DXC / VA
 * April 13, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSDataItemWriter extends CBSSBaseMultiItemWriter<Entry<APSSite, List<APSPatient>>>
{
    // Injected property
	private LoadAPPSService loadAPPSService;

	public LoadAPPSService getLoadAPPSService()
	{
		return this.loadAPPSService;
	}

	public void setLoadAPPSService(LoadAPPSService inLoadAPPSService)
	{
		this.loadAPPSService = inLoadAPPSService;
	}

    @Override
    public void write(List<? extends Entry<APSSite, List<APSPatient>>> entries) throws Exception
    {
        this.logger.debug("Begin Write Data ...");

        // Do not attempt to write if forced stop or entries are empty.
        if (this.isForceStop || entries == null || entries.isEmpty())
        {
            this.logger.debug("End Write Data - No data to write.");
            return;
        }

        String message = this.loadAPPSService.save(entries);

        if (message != null)
        {
            stopJob(WRITE_FAILURE_STATUS, "Attempt to save data to database failed." + LINE_FEED + message);
        }

        this.logger.debug("End Write Data.");
    }
}
