package gov.va.cpss.job.apps;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.apps.APPSCompositeData;
import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSSite;

import gov.va.cpss.job.CBSSBaseItemProcessor;

/**
 * 
 * Custom ItemProcessor used by the Load APPS Payments Data batch job to process
 * records parsed from the input flat file prior to writing the records to the
 * database.
 * 
 * Copyright DXC / VA
 * April 12, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSDataItemProcessor extends CBSSBaseItemProcessor<APPSCompositeData, Entry<APSSite, List<APSPatient>>>
{
    @Override
    public Entry<APSSite, List<APSPatient>> process(APPSCompositeData compositeData) throws Exception
    {
        this.logger.debug("Process data.");

        if (compositeData == null || compositeData.getSiteEntry() == null)
        {
            return null;
        }

        return compositeData.getSiteEntry();
    }
}
