package gov.va.cpss.job;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

/**
 * Custom JobExecutionListener used by CBSS batch jobs to set the job execution
 * exit status based on JOB_FAILURE_KEY and JOB_FAILURE_MESSAGE_KEY.
 * 
 */
public class SetExitStatusJobExecutionListener implements JobExecutionListener {

	private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

	@Override
	public void beforeJob(JobExecution jobExecution) {
		logger.info("Beginning Job Execution");
	}

	@Override
	public void afterJob(JobExecution jobExecution) {

		if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_KEY)) {

			final String exitStatus = jobExecution.getExecutionContext().getString(JOB_FAILURE_KEY);

			if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_MESSAGE_KEY)) {

				final String exitMessage = jobExecution.getExecutionContext().getString(JOB_FAILURE_MESSAGE_KEY);

				logger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

				jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
			} else {

				logger.error("JobFailure detected, setting exit status (" + exitStatus + ")");

				jobExecution.setExitStatus(new ExitStatus(exitStatus));
			}
		} else {
			jobExecution.setExitStatus(ExitStatus.COMPLETED);
		}

		logger.info("Ending Job Execution");
	}

}
