package gov.va.cpss.job;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.cpss.job.sendapps.SendAPPSProcessingConstants;
import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.BatchRunProcess;
import gov.va.cpss.service.SendAPPSService;

@SuppressWarnings("nls")
public class SendAPPSAITCCCPCJob extends CbssBaseJob {

	@Autowired
	private FlowJob SendAPPSJobBatch;

	@Autowired
	private SendAPPSService sendAPPSService;

	@Override
	protected FlowJob getJob() {
		return this.SendAPPSJobBatch;
	}

	@Override
	protected boolean runJob(BatchRun bR, FlowJob job) {
		boolean successful = false;

		try {
			BatchRunProcess batchRunProcess = this.sendAPPSService.startJob(bR, null).get();

			JobParameters parameters = getParameters(batchRunProcess);
			JobExecution execution = executeJob(job, parameters);

			successful = (this.sendAPPSService.endJob(execution, batchRunProcess) == null);
			jobLogger.debug("sendAPPSService.endSendCBSJob(): " + successful);

			if (successful) {
				String totalFilesSent = "UNKNOWN";
				if (execution.getExecutionContext().containsKey(SendAPPSProcessingConstants.APPS_FILES_SENT_KEY)) {
					totalFilesSent = ""
							+ execution.getExecutionContext().getLong(SendAPPSProcessingConstants.APPS_FILES_SENT_KEY);
				} else {
					jobLogger.error("Unable to obtain key from process results: "
							+ SendAPPSProcessingConstants.APPS_FILES_SENT_KEY);
				}

				String totalAPPSStatements = "UNKNOWN";
				if (execution.getExecutionContext().containsKey(SendAPPSProcessingConstants.APPS_STATEMENTS_SENT_KEY)) {
					totalAPPSStatements = "" + execution.getExecutionContext()
							.getLong(SendAPPSProcessingConstants.APPS_STATEMENTS_SENT_KEY);
				} else {
					jobLogger.error("Unable to obtain key from process results: "
							+ SendAPPSProcessingConstants.APPS_STATEMENTS_SENT_KEY);
				}

				buildInfoMessage(totalFilesSent, totalAPPSStatements);
			}
		} catch (Exception e) {
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			jobLogger.error(sw);
			super.appendErrorMessage(e.getMessage());
			successful = false;
		}

		return successful;
	}

	/**
	 * @return JobParameters object for this batch job run.
	 */
	@SuppressWarnings("static-method")
	protected JobParameters getParameters(BatchRunProcess batchRunProcess) {
		// Build job parameters for the input filename, received primary key id,
		// and the created or modified by string.
		return new JobParametersBuilder()
				.addLong(SendAPPSProcessingConstants.APPS_BATCHRUNPROCESS_ID_KEY, new Long(batchRunProcess.getId()))
				.addString(SendAPPSProcessingConstants.APPS_OUTPUT_FILE_NAME_KEY, batchRunProcess.getFileName())
				.toJobParameters();
	}

	private void buildInfoMessage(String totalFilesSent, String totalAPPSStatements) {
		StringBuffer strBuff = new StringBuffer();
		strBuff.append("Total APPS Files Sent: " + totalFilesSent + "\n");
		strBuff.append("Total APPS Statements Sent: " + totalAPPSStatements);
		appendInfoMessage(strBuff.toString());
	}

}