package gov.va.cpss.job;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.BlockingQueue;

/**
 * Implementation of CbssSftpItemReader used by a batch job to read data over an
 * sftp file stream and process that data per line record.
 * 
 * @author DNS  
 */
public class CbssSftpReadLineItemReader<T> extends CbssSftpItemReader<T> {

	@Override
	protected CbssStreamToQueueThread getQueueBuilderThread(long expectedByteCount, InputStream in,
			BlockingQueue<String> outputQueue) {
		try {
			return new CbssStreamToQueueThreadReadLineImpl(expectedByteCount, in, outputQueue);
		} catch (UnsupportedEncodingException e) {
			readerLogger.error("Error creating data stream processing thread: " + e.getMessage());
		}
		return null;
	}

}
