package gov.va.cpss.job;

import static gov.va.cpss.job.CbssJobProcessingConstants.WRITE_FAILURE_STATUS;

import java.util.List;

/**
 * 
 * Implementation of ItemWriter used to handle writing of raw records for paging read / process.
 * 
 * Copyright HPE / VA
 * February 3, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public abstract class CBSSPagingMultiItemWriter<T> extends CBSSBaseMultiItemWriter<List<? extends T>>
{
    /**
     * 
     * The first (left-most) list is for commit interval:
     * If the commit interval is 1, this list will only have one element - a list of one list;
     * If the commit interval is 10, then the list will have ten elements - a list of ten lists.
     * 
     * In the case of paging read / process / write, the commit interval needs to be set at 1,
     * otherwise, the last page that have less items than the page size may not be written.
     * 
     */
    @Override
    public void write(final List<? extends List<? extends T>> itemsList) throws Exception
    {
        //this.logger.debug("Begin Write ...");

        // Do not attempt to write if forced stop.
        if (this.isForceStop)
        {
            return;
        }

        if (itemsList != null && !itemsList.isEmpty())
        {
            for (List<? extends T> items : itemsList)
            {
                if (items != null &&  !items.isEmpty())
                {
                    this.logger.debug("Writing ...");

                    if (!doWrite(items))
                    {
                        stopJob(WRITE_FAILURE_STATUS, "Attempt to write data failed.");
                    }
                }
            }
        }

        //this.logger.debug("End Write.");
    }

    abstract protected boolean doWrite(final List<? extends T> inItems);
}
