package gov.va.cpss.jasper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PdfSiteStatementCollectionBean {
	
	//When the statement has additional comments, we should count this else layout lines will go down.
	private static final int ADDITIONAL_STATEMENT_LENGTH = 3;
	
	private List<PdfSiteStatementBean> siteStatementL;
	
	private List<PdfSiteStatementBean> siteStatementCouponPageL;
	
	private List<PdfSiteStatementBean> siteStatementExtensionPageL;

	public List<PdfSiteStatementBean> getSiteStatementL() {
		return siteStatementL;
	}

	public void setSiteStatementL(List<PdfSiteStatementBean> siteStatementL) {
		this.siteStatementL = siteStatementL;
	}
	
	public List<PdfSiteStatementBean> getSiteStatementCouponPageL() {
		return siteStatementCouponPageL;
	}

	public void setSiteStatementCouponPageL(List<PdfSiteStatementBean> siteStatementCouponPageL) {
		this.siteStatementCouponPageL = siteStatementCouponPageL;
	}

	public List<PdfSiteStatementBean> getSiteStatementExtensionPageL() {
		return siteStatementExtensionPageL;
	}

	public void setSiteStatementExtensionPageL(List<PdfSiteStatementBean> siteStatementExtensionPageL) {
		this.siteStatementExtensionPageL = siteStatementExtensionPageL;
	}

	/**
	 * Return the size of the bean in units of lines that would be written to the report.
	 * @param statementL The list of beans for which to check the size.
	 * @return Integer representing the total number of lines for the bean.
	 */
	public int size(List<PdfSiteStatementBean> statementL) {
		int s = 0;
		if (statementL == null) {
			return s;
		}
		for (PdfSiteStatementBean b : statementL) {
			s += b.size();
			if(b.getLateStmtFlag()) s=s+ADDITIONAL_STATEMENT_LENGTH;
		}
		return s;
	}
	
	/**
	 * Return the number of lines reserved for the coupon page that would be written to the report.
	 * @return Integer representing the total number of lines for the coupon page.
	 */
	public int couponSize() {
		return size(siteStatementCouponPageL);
	}
	
	/**
	 * Return the number of lines reserved for the extension page that would be written to the report.
	 * @return Integer representing the total number of lines for the extension pages.
	 */
	public int extensionSize() {
		return size(siteStatementExtensionPageL);
	}
	
	/**
	 * Split the bean into two input lists for the coupon page and remaining extension pages.
	 * @param length The length allowed for the coupon page.
	 */
	public void split(final int length) {
		// Only truncate if size bigger than allowed length.
		if (size(siteStatementL) > length) {
			
			siteStatementExtensionPageL = new ArrayList<>();
			
			// Get the index of the statement to truncate.
			int truncatedIndex = calculateIndexOfTruncatedStatement(length);
			
			// Only remove subsequent statements if the calculated truncated index is valid.
			if (truncatedIndex < siteStatementL.size()) {
				for (int i = siteStatementL.size() - 1; i > truncatedIndex; --i) {
					
					// Remove the site statement from the original list and add to the extension page.
					PdfSiteStatementBean siteStatementBean = siteStatementL.remove(i);
					siteStatementExtensionPageL.add(siteStatementBean);
				}
			}
			
			// Now truncate the last statement if necessary.
			if (size(siteStatementL) > length) {
				
				PdfSiteStatementBean truncatedBean = siteStatementL.get(truncatedIndex).split(size(siteStatementL) - length);
				siteStatementExtensionPageL.add(truncatedBean);
			}
			
			siteStatementCouponPageL = siteStatementL;
			// Flip the order.
			Collections.reverse(siteStatementExtensionPageL);
			
		} else {
			
			siteStatementCouponPageL = siteStatementL;
		}
	}
	
	/**
	 * Adds blank lines to the final site to stretch the box to the footer of the page. This should only be
	 * called after split.
	 * @param length The length allowed for the coupon page.
	 */
	public void addFillerSpace(final int couponLength, final int extensionLength) {		
		// Ensure split has been called first.
		if(siteStatementCouponPageL == null){
			return;
		}
		
		// Always add one space to ensure border is flush
		int spacesToAdd = 1;
		final PdfSiteStatementBean finalBean;
		
		// If the extension page is empty, then add to the coupon page
		if(size(siteStatementExtensionPageL) == 0) {
			spacesToAdd += couponLength - size(siteStatementCouponPageL);
			finalBean = siteStatementCouponPageL.get(siteStatementCouponPageL.size()-1);
			
		} else {
			spacesToAdd += extensionLength - (size(siteStatementExtensionPageL)%extensionLength);
			finalBean = siteStatementExtensionPageL.get(siteStatementExtensionPageL.size()-1);
			//System.out.println("filler space2  "+ spacesToAdd);
		}
		
		for(int i=0; i < (spacesToAdd); i++) {
			finalBean.getFillerSpace().add(" ");
		}
	}

	/**
	 * Calculate the index of the list of PdfSiteStatementBeans for which to split into a coupon list and extension list.
	 * @param length The length allowed for the coupon page.
	 * @return The index to truncate the list.
	 */
	private int calculateIndexOfTruncatedStatement(final int length) {
		int i = 0;
		int s = 0;
		
		for (i = 0; i < siteStatementL.size(); ++i) {
			s += siteStatementL.get(i).size();
			
			if (s >= length) {
				return i;
			}
		}
		return i;
	}
	
}
