package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.model.icn.VistaAcntHist;

/**
 * 
 * VistA Account History row mapper that maps a DB row to model.
 * 
 * Sprint 5 - Epic 349068, Task 370262 DAO Implementation.
 *
 * Copyright HPE / VA
 * August 29, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public class VistaAcntHistRowMapper implements RowMapper<VistaAcntHist>
{
	/**
	 * Default Constructor
	 */
	public VistaAcntHistRowMapper()
	{
		// Auto-generated constructor stub
	}

	@SuppressWarnings("nls")
	@Override
	public VistaAcntHist mapRow(ResultSet rs, int rowNum) throws SQLException
	{
		VistaAcntHist vistaAcntHist = new VistaAcntHist();

		vistaAcntHist.setId(rs.getLong("ID"));
		vistaAcntHist.setDfn(rs.getLong("DFN"));
		vistaAcntHist.setStationNum(rs.getString("STATIONNUM"));
		vistaAcntHist.setNewIcn(rs.getString("NEWICN"));
		vistaAcntHist.setOldIcn(rs.getString("OLDICN"));
		vistaAcntHist.setOldCbssAcntId(rs.getLong("OLDCBSSACNTID"));
		vistaAcntHist.setStatusId(rs.getInt("STATUSID"));

		// Audit fields
		vistaAcntHist.setCreatedBy(rs.getString("CREATEDBY"));
		vistaAcntHist.setCreatedDate(rs.getDate("CREATEDDATE"));
		vistaAcntHist.setModifiedBy(rs.getString("MODIFIEDBY"));
		vistaAcntHist.setModifiedDate(rs.getDate("MODIFIEDDATE"));

		return vistaAcntHist;
	}
}
