package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

/**
 * 
 * Map a single String field specified by the fieldName property.
 * 
 * @author Brad Pickle
 *
 */
public class StringRowMapper implements RowMapper<String> {
	
	private String fieldName;

	@Override
	public String mapRow(ResultSet rs, int rowNum) throws SQLException {        		
		return rs.getString(fieldName);
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

}
