package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.CBSSAuditDatesDAO;
import gov.va.cpss.dao.PrintAckRecDAO;
import gov.va.cpss.model.printack.PrintAckRec;

/**
 * An implementation of the PrintAckReckAO interface.
 * 
 * @author Brad Pickle
 */
public class PrintAckRecDAOImpl implements PrintAckRecDAO {

	private JdbcTemplate jdbcTemplate;

	private CBSSAuditDatesDAO cbssAuditDatesDAO;

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public CBSSAuditDatesDAO getCbssAuditDatesDAO() {
		return cbssAuditDatesDAO;
	}

	public void setCbssAuditDatesDAO(CBSSAuditDatesDAO cbssAuditDatesDAO) {
		this.cbssAuditDatesDAO = cbssAuditDatesDAO;
	}

	@Override
	public long insert(final PrintAckRec printAckRec) {

		// insert
		final String sql = "INSERT INTO PrintAckRec (stationNum, dateReceived, statusId, fileName, batchRunId) VALUES (?, ?, ?, ?, ?)";
		KeyHolder keyHolder = new GeneratedKeyHolder();

		jdbcTemplate.update(new PreparedStatementCreator() {
			@Override
			public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
				PreparedStatement ps = connection.prepareStatement(sql, new String[] { "id" });

				ps.setString(1, printAckRec.getStationNum());
				ps.setTimestamp(2, printAckRec.getDateReceived());
				ps.setInt(3, printAckRec.getStatusId());
				ps.setString(4, printAckRec.getFileName());
				ps.setInt(5, printAckRec.getBatchRunId());

				return ps;
			}
		}, keyHolder);
		printAckRec.setId(keyHolder.getKey().longValue());

		// Load the new audit fields and set on cbsSiteTrans
		cbssAuditDatesDAO.getAuditDates("PrintAckRec", printAckRec.getId(), printAckRec);

		return printAckRec.getId();
	}

	@Override
	public void updateStatus(final PrintAckRec printAckRec) {

		final String sql = "UPDATE PrintAckRec SET statusId = ? where id=?";
		jdbcTemplate.update(sql, printAckRec.getStatusId(), printAckRec.getId());

		// Load the new audit fields and set on printAckRec
		cbssAuditDatesDAO.getAuditDates("PrintAckRec", printAckRec.getId(), printAckRec);
	}

	@Override
	public int updateStatus(final List<Long> printAckRecIdList, final int statusId) {
		if ((printAckRecIdList == null) || (printAckRecIdList.size() == 0))
			return 0;

		final String sql = "UPDATE PrintAckRec SET statusId = " + statusId + " where id=?";
		
		int numRowsUpdated = 0;
		for (int i = 0; i < printAckRecIdList.size(); i++) {
			numRowsUpdated += jdbcTemplate.update(sql, printAckRecIdList.get(i));
		}

		return numRowsUpdated;
	}

	@Override
	public PrintAckRec get(long id) {
		final String sql = "SELECT * FROM PrintAckRec WHERE id = " + id;

		final List<PrintAckRec> printAckRecL = jdbcTemplate.query(sql, new RowMapper<PrintAckRec>() {

			@Override
			public PrintAckRec mapRow(ResultSet rs, int rowNum) throws SQLException {

				PrintAckRec printAckRec = new PrintAckRec();

				printAckRec.setId(rs.getLong("id"));
				printAckRec.setStationNum(rs.getString("stationNum"));
				printAckRec.setDateReceived(rs.getTimestamp("dateReceived"));
				printAckRec.setStatusId(rs.getInt("statusId"));
				printAckRec.setFileName(rs.getString("fileName"));
				printAckRec.setBatchRunId(rs.getInt("batchRunId"));
				printAckRec.setCreatedBy(rs.getString("createdBy"));
				printAckRec.setCreatedDate(rs.getDate("createdDate"));
				printAckRec.setModifiedBy(rs.getString("modifiedBy"));
				printAckRec.setModifiedDate(rs.getDate("modifiedDate"));

				return printAckRec;
			}
		});

		return (printAckRecL.size() > 0) ? printAckRecL.get(0) : null;
	}

}
