package gov.va.cpss.dao.impl;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.fps.PSDetails;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in
 * prepared statement for batch data insert into the PSDetails table.
 * 
 * @author DNS   
 */
public class PSDetailsItemPreparedStatementSetter implements ItemPreparedStatementSetter<PSDetails> {

	private final Logger processorLogger;

	public PSDetailsItemPreparedStatementSetter() {
		processorLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	@Override
	public void setValues(PSDetails arg0, PreparedStatement arg1) throws SQLException {

		processorLogger.debug("Setting values to insert PD row");

		arg1.setLong(1, arg0.getPsPatientId());
		// Null is allowed.
		if (arg0.getDatePosted() == null) {
			arg1.setDate(2, null);
		} else {
			arg1.setDate(2, new Date(arg0.getDatePosted().getTime()));
		}
		arg1.setString(3, arg0.getTransDesc());
		arg1.setDouble(4, arg0.getTransAmount().getDouble());
		arg1.setString(5, arg0.getTransAmount().getCobol());
		arg1.setString(6, arg0.getReferenceNum());
		arg1.setString(7, arg0.getIcnNumber());
		arg1.setInt(8, arg0.getSeqNum());
	
	}

}
