package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.dao.PSDetailsDAO;
import gov.va.cpss.model.fps.PSDetails;
import gov.va.cpss.model.fps.PSSite;

/**
 * An implementation of the PSDetailsDAO interface.
 */
public class PSDetailsDAOImpl implements PSDetailsDAO {

	private JdbcTemplate jdbcTemplate;

	private static final String PSDETAILS_SELECT_FIELDS = "PSDetails.id AS id, "
			+ "PSDetails.psPatient_Id AS psPatient_Id, PSDetails.datePosted AS datePosted, "
			+ "PSDetails.transDesc AS transDesc, PSDetails.transAmountRaw AS transAmountRaw, "
			+ "PSDetails.referenceNum AS referenceNum, PSDetails.icnNumber AS icnNumber, "
			+ "PSDetails.seqNum AS seqNum, PSDetails.createdBy AS createdBy, "
			+ "PSDetails.createdDate AS createdDate, PSDetails.modifiedBy AS modifiedBy, "
			+ "PSDetails.modifiedDate AS modifiedDate ";

	public PSDetailsDAOImpl() {
	}

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public Long getLastIndex() {

		// query
		final String sql = "SELECT * FROM (SELECT * FROM PSDetails ORDER BY id DESC) WHERE rownum <= 1";

		List<Long> results = jdbcTemplate.query(sql, new RowMapper<Long>() {
			@Override
			public Long mapRow(ResultSet rs, int row) throws SQLException {
				return new Long(rs.getLong(1));
			}
		});

		if ((results != null) && !results.isEmpty()) {
			return results.get(0);
		}

		return null;
	}

	@Override
	public List<PSDetails> getAllByPSSiteID(final PSSite psSite) {

		if (psSite != null) {

			// Get all PSDetails ordered by ID that are in all PSPatient
			// associated with the specified PSSite.

			// Original query
			// String sql = "SELECT * FROM (SELECT * FROM PSDetails order by id) WHERE psPatient_Id IN (SELECT id FROM (SELECT * FROM PSPatient order by id) WHERE psSite_Id = "
			// + psSite.getId() + ")";

			// Query optimized by removing nested queries and delaying order by
			// to last step. Replaced with simple join. - Brad 12/19/2016
			String sql = "SELECT " + PSDETAILS_SELECT_FIELDS
					+ "FROM PSDetails INNER JOIN PSPatient ON PSDetails.psPatient_Id = PSPatient.id "
					+ "WHERE PSPatient.psSite_Id = " + psSite.getId() + " ORDER BY PSDetails.id";
			
			List<PSDetails> detailsL = jdbcTemplate.query(sql, new RowMapper<PSDetails>() {

				@Override
				public PSDetails mapRow(ResultSet rs, int rowNum) throws SQLException {

					PSDetails details = new PSDetails();
					details.setId(rs.getLong("id"));
					details.setPsPatientId(rs.getLong("psPatient_Id"));

					// Null is allowed.
					if (rs.getDate("datePosted") == null) {
						details.setDatePosted(null);
					} else {
						details.setDatePosted(new java.util.Date(rs.getDate("datePosted").getTime()));
					}
					details.setTransDesc(rs.getString("transDesc"));
					details.setTransAmount(new Money(rs.getString("transAmountRaw")));
					details.setReferenceNum(rs.getString("referenceNum"));
					details.setIcnNumber(rs.getString("icnNumber"));
					details.setSeqNum(rs.getInt("seqNum"));
					details.setCreatedBy(rs.getString("createdBy"));
					details.setCreatedDate(new java.util.Date(rs.getDate("createdDate").getTime()));
					details.setModifiedBy(rs.getString("modifiedBy"));
					details.setModifiedDate(new java.util.Date(rs.getDate("modifiedDate").getTime()));

					return details;
				}
			});
			return detailsL;
		}

		return null;
	}

	public static String getInsertPSDetailsSql() {
		return "INSERT INTO PSDetails(psPatient_Id, datePosted, transDesc, transAmount, "
				+ "transAmountRaw, referenceNum, icnNumber, seqNum) values(?, ?, ?, ?, ?, ?, ?, ?)";
	}
}
