package gov.va.cpss.dao.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;

import gov.va.cpss.model.ProcessStatus;
import gov.va.cpss.service.CbsService;

/**
 * Custom ItemPreparedStatementSetter for JdbcBatchItemWriter to set values in
 * prepared statement for batch data to update a CBSStmt to replaced status.
 * 
 * @author DNS   
 */
public class CBSStmtReplacedItemPreparedStatementSetter implements ItemPreparedStatementSetter<Long> {

	private final Logger setterLogger;

	private CbsService cbsService;

	public CBSStmtReplacedItemPreparedStatementSetter() {
		setterLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	public CbsService getCbsService() {
		return cbsService;
	}

	public void setCbsService(CbsService cbsService) {
		this.cbsService = cbsService;
	}

	@Override
	public void setValues(Long arg0, PreparedStatement arg1) throws SQLException {

		setterLogger.debug("Setting values to update CBSStmt status to replaced row");

		arg1.setInt(1, cbsService.getProcessStatusDAO().getStatusFromEnum(ProcessStatus.Status.REPLACED));
		arg1.setLong(2, arg0);
	}

}
