package gov.va.cpss.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import gov.va.cpss.dao.BatchRunDAO;
import gov.va.cpss.model.BatchRun;

/**
 * An implementation of the TaskDAO interface.
 */
public class BatchRunDAOImpl implements BatchRunDAO {

    private JdbcTemplate jdbcTemplate;

    public BatchRunDAOImpl() {
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public int save(final BatchRun batchRun) {
        // insert
        final String sql = "INSERT INTO batchrun (job_id, startdate, enddate, status_id, message) VALUES (?, ?, ?, ?, ?)";
        KeyHolder keyHolder = new GeneratedKeyHolder();
        
        jdbcTemplate.update(new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, new String[]{"id"});
                ps.setInt(1, batchRun.getJobId());
                ps.setTimestamp(2, batchRun.getStartDate());
                ps.setTimestamp(3, batchRun.getEndDate());
                ps.setInt(4, batchRun.getStatusId());
                ps.setString(5, batchRun.getMessage());
                return ps;
            }
        }, keyHolder);

        return keyHolder.getKey().intValue();
    }

    @Override
    public void update(BatchRun batchRun) {
        // update
        String sql = "UPDATE batchrun SET startdate=?, enddate=?, status_id=?, message=? WHERE id=?";
        jdbcTemplate.update(sql, batchRun.getStartDate(), batchRun.getEndDate(), batchRun.getStatusId(),
                batchRun.getMessage(), batchRun.getId());
    }

    public BatchRun getLastRun() {

        String sql = "SELECT * FROM (SELECT * FROM batchrun ORDER BY id DESC) WHERE rownum <= 1";
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchRun>() {

            @Override
            public BatchRun extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchRun batchRun = new BatchRun();
                    batchRun.setId(rs.getInt("id"));
                    batchRun.setJobId(rs.getInt("job_id"));
                    batchRun.setStartDate(rs.getTimestamp("startdate"));
                    batchRun.setEndDate(rs.getTimestamp("enddate"));
                    batchRun.setStatusId(rs.getInt("status_id"));
                    batchRun.setMessage(rs.getString("message"));
                    return batchRun;
                }

                return null;
            }

        });
    }

    @Override
    public BatchRun getLastRunByBatchJobId(int jobId) {

        String sql = "SELECT * FROM (SELECT * FROM batchrun where job_id = " + jobId + " ORDER BY id DESC) WHERE rownum <= 1";
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchRun>() {

            @Override
            public BatchRun extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchRun batchRun = new BatchRun();
                    batchRun.setId(rs.getInt("id"));
                    batchRun.setJobId(rs.getInt("job_id"));
                    batchRun.setStartDate(rs.getTimestamp("startdate"));
                    batchRun.setEndDate(rs.getTimestamp("enddate"));
                    batchRun.setStatusId(rs.getInt("status_id"));
                    batchRun.setMessage(rs.getString("message"));
                    return batchRun;
                }

                return null;
            }

        });
    }
}
