package gov.va.cpss.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.BatchJobDAO;
import gov.va.cpss.model.BatchJob;

/**
 * An implementation of the BatchJobDAO interface.
 */
public class BatchJobDAOImpl implements BatchJobDAO {

    private JdbcTemplate jdbcTemplate;

    public BatchJobDAOImpl() {
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public List<BatchJob> batchList() {
        String sql = "SELECT * FROM batchjob";
        List<BatchJob> batchL = jdbcTemplate.query(sql, new RowMapper<BatchJob>() {

            @Override
            public BatchJob mapRow(ResultSet rs, int rowNum) throws SQLException {
                BatchJob batchJob = new BatchJob();

                batchJob.setId(rs.getInt("id"));
                batchJob.setName(rs.getString("name"));
                batchJob.setDescription(rs.getString("description"));
                batchJob.setEmail(rs.getString("email"));
                batchJob.setSchedule(rs.getString("schedule"));
                batchJob.setTypeId(rs.getInt("type_id"));
                batchJob.setSourceType(rs.getInt("sourcetype"));

                return batchJob;
            }

        });

        return batchL;
    }

    @Override
    public BatchJob getBatchJob(int id) {

        String sql = "SELECT * FROM batchjob where id = " + id;
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchJob>() {

            @Override
            public BatchJob extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchJob batchJob = new BatchJob();
                    batchJob.setId(rs.getInt("id"));
                    batchJob.setName(rs.getString("name"));
                    batchJob.setDescription(rs.getString("description"));
                    batchJob.setEmail(rs.getString("email"));
                    batchJob.setSchedule(rs.getString("schedule"));
                    batchJob.setTypeId(rs.getInt("type_id"));
                    batchJob.setSourceType(rs.getInt("sourcetype"));

                    return batchJob;
                }

                return null;
            }

        });
    }

    @Override
    public void update(BatchJob batchJob) {
        // update
        String sql = "UPDATE batchjob SET name=?, email=?, schedule=?, type_id=? WHERE id=?";
        jdbcTemplate.update(sql, batchJob.getName(), batchJob.getEmail(), batchJob.getSchedule(), batchJob.getTypeId(),
                batchJob.getId());
    }

    @Override
    public BatchJob getBatchJobByName(String name) {
        String sql = "SELECT * FROM batchjob where name = '" + name + "'";
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchJob>() {

            @Override
            public BatchJob extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchJob batchJob = new BatchJob();
                    batchJob.setId(rs.getInt("id"));
                    batchJob.setName(rs.getString("name"));
                    batchJob.setDescription(rs.getString("description"));
                    batchJob.setEmail(rs.getString("email"));
                    batchJob.setSchedule(rs.getString("schedule"));
                    batchJob.setTypeId(rs.getInt("type_id"));
                    batchJob.setSourceType(rs.getInt("sourcetype"));
                    

                    return batchJob;
                }

                return null;
            }

        });
    }
    
    @Override
    public BatchJob getBatchJobByNameAndSourceType(String name, int sourceType) {
        String sql = "SELECT * FROM batchjob where name = '" + name + "'" + " AND sourceType = " + sourceType;
        return jdbcTemplate.query(sql, new ResultSetExtractor<BatchJob>() {

            @Override
            public BatchJob extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    BatchJob batchJob = new BatchJob();
                    batchJob.setId(rs.getInt("id"));
                    batchJob.setName(rs.getString("name"));
                    batchJob.setDescription(rs.getString("description"));
                    batchJob.setEmail(rs.getString("email"));
                    batchJob.setSchedule(rs.getString("schedule"));
                    batchJob.setTypeId(rs.getInt("type_id"));
                    batchJob.setSourceType(rs.getInt("sourcetype"));
                    

                    return batchJob;
                }

                return null;
            }

        });
    }

	@Override
	public List<BatchJob> cbssBatchList() {
		 String sql = "SELECT * FROM batchjob where sourceType = 1";
	        List<BatchJob> batchL = jdbcTemplate.query(sql, new RowMapper<BatchJob>() {

	            @Override
	            public BatchJob mapRow(ResultSet rs, int rowNum) throws SQLException {
	                BatchJob batchJob = new BatchJob();

	                batchJob.setId(rs.getInt("id"));
	                batchJob.setName(rs.getString("name"));
	                batchJob.setDescription(rs.getString("description"));
	                batchJob.setEmail(rs.getString("email"));
	                batchJob.setSchedule(rs.getString("schedule"));
	                batchJob.setTypeId(rs.getInt("type_id"));
	                batchJob.setSourceType(rs.getInt("sourcetype"));

	                return batchJob;
	            }

	        });

	        return batchL;
	    }
	

	@Override
	public List<BatchJob> appsBatchList() {
		 String sql = "SELECT * FROM batchjob where sourceType = 2";
	        List<BatchJob> batchL = jdbcTemplate.query(sql, new RowMapper<BatchJob>() {

	            @Override
	            public BatchJob mapRow(ResultSet rs, int rowNum) throws SQLException {
	                BatchJob batchJob = new BatchJob();

	                batchJob.setId(rs.getInt("id"));
	                batchJob.setName(rs.getString("name"));
	                batchJob.setDescription(rs.getString("description"));
	                batchJob.setEmail(rs.getString("email"));
	                batchJob.setSchedule(rs.getString("schedule"));
	                batchJob.setTypeId(rs.getInt("type_id"));
	                batchJob.setSourceType(rs.getInt("sourcetype"));
	                batchJob.setScheduleDate("ProtoDate");

	                return batchJob;
	            }

	        });

	        return batchL;
	    }

}
