package gov.va.cpss.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import gov.va.cpss.dao.APSSitePatientDAO;

import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.apps.APSSitePatient;

/**
 * An implementation of the APSSitePatientDAO interface.
 * 
 * Copyright HPE / VA
 * January 18, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
*/
@SuppressWarnings("nls")
public class APSSitePatientDAOImpl extends CBSSBaseDAOImpl implements APSSitePatientDAO
{
    public static final String TABLE_NAME = "APSSitePatient";


    static class APSSitePatientRowMapper implements RowMapper<APSSitePatient>
    {
        APSSitePatientRowMapper() {
        }

        @Override
        public APSSitePatient mapRow(ResultSet rs, int rowNum) throws SQLException
        {
            APSSitePatient sitePatient = new APSSitePatient();

            sitePatient.setId(rs.getInt(ID));
            sitePatient.setSiteStmtId(rs.getInt("siteStmtId"));
            sitePatient.setIcn(rs.getString("icn"));
            sitePatient.setDfn(rs.getLong("dfn"));
            sitePatient.setAccountNumber(rs.getString("oldAcntNum"));
            sitePatient.setFirstName(rs.getString("firstName"));
            sitePatient.setLastName(rs.getString("lastName"));
            sitePatient.setMiddleName(rs.getString("middleName"));
            sitePatient.setAddress1(rs.getString("address1"));
            sitePatient.setAddress2(rs.getString("address2"));
            sitePatient.setAddress3(rs.getString("address3"));
            sitePatient.setCity(rs.getString("city"));
            sitePatient.setState(rs.getString("state"));
            sitePatient.setZipCode(rs.getString("zipCode"));
            sitePatient.setCountry(rs.getString("country"));

            return sitePatient;
        }
    }

    @Override
    public APSSitePatient getSitePatientForSiteStatement(long siteStmtId) {
        final String sql = "SELECT * FROM APSSitePatient WHERE siteStmtId=" + siteStmtId;
        final APSSitePatient results = this.jdbcTemplate.query(sql, new APSSitePatientRowMapper()).get(0);
        return results;
    }


    @Override
    public String getTableName()
    {
        return TABLE_NAME;
    }

    @Override
    public String getInsertSQL()
    {
        return  "INSERT " + PARALLEL_HINT + " INTO " + TABLE_NAME +
                " (siteStmtId, icn, dfn, oldAcntNum, firstName, lastName, middleName, address1, address2, address3, city, state, zipCode, country) " +
                " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    protected void mapRows(PreparedStatement ps, CBSSAbstractModel model) throws SQLException
    {
        APSSitePatient patient = (APSSitePatient) model;

        ps.setLong(1, patient.getSiteStmtId());
        ps.setString(2, patient.getIcn());
        ps.setLong(3, patient.getDfn());
        ps.setString(4, patient.getAccountNumber());
        ps.setString(5, patient.getFirstName());
        ps.setString(6, patient.getLastName());
        ps.setString(7, patient.getMiddleName());
        ps.setString(8, patient.getAddress1());
        ps.setString(9, patient.getAddress2());
        ps.setString(10, patient.getAddress3());
        ps.setString(11, patient.getCity());
        ps.setString(12, patient.getState());
        ps.setString(13, patient.getZipCode());
        ps.setString(14, patient.getCountry());
    }

    @Override
    protected CBSSAbstractModel mapResult(ResultSet rs) throws SQLException
    {
        APSSitePatient sitePatient = new APSSitePatient();

        sitePatient.setId(rs.getInt("id"));
        sitePatient.setSiteStmtId(rs.getInt("siteStmtId"));
        sitePatient.setIcn(rs.getString("icn"));
        sitePatient.setDfn(rs.getLong("dfn"));
        sitePatient.setAccountNumber(rs.getString("oldAcntNum"));
        sitePatient.setFirstName(rs.getString("firstName"));
        sitePatient.setLastName(rs.getString("lastName"));
        sitePatient.setMiddleName(rs.getString("middleName"));
        sitePatient.setAddress1(rs.getString("address1"));
        sitePatient.setAddress2(rs.getString("address2"));
        sitePatient.setAddress3(rs.getString("address3"));
        sitePatient.setCity(rs.getString("city"));
        sitePatient.setState(rs.getString("state"));
        sitePatient.setZipCode(rs.getString("zipCode"));
        sitePatient.setCountry(rs.getString("country"));

        // Audit fields
        mapAuditFields(rs, sitePatient);

        return sitePatient;
    }

}
