package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.icn.VistaAccount;

/**
 * Data Access Object interface for the VistaAccount table.
 * 
 * @author DNS 
 */
public interface VistaAccountDAO extends CBSSBaseDAO {

	public boolean exists(final long dfn, final String stationNum);

	public boolean save(final int statusId, final long dfn, final String stationNum, final String icnNumber, final long cbssAcntId);

	/**
	 * Batch update
	 * 
	 * @param inVistaAccounts
	 * 
	 */

	public int[] update(List<VistaAccount> inVistaAccounts);

	/**
	 * Batch select
	 * 
	 * @param inICNs
	 * 
	 */
	public List<VistaAccount> batchSelect(String[] inICNs);

	/**
	 * Get VistA Account
	 * 
	 * @param inDFN
	 * @param inStationNum
	 * 
	 */
	public VistaAccount getVistaAccount(final long inDFN, final String inStationNum);
}
