package gov.va.cpss.dao;

import gov.va.cpss.model.bal.SiteBalRec;

/**
 * Data Access Object interface for the SiteBalRec table.
 * 
 */
public interface SiteBalRecDAO {
	
	/**
	 * Return the specified SiteBalRec by id.
	 */
	public SiteBalRec getById(long id);

	/**
	 * Save a SiteBalRec and return the unique id.
	 */
	public long save(SiteBalRec siteBalRec);
	
	/**
	 * Delete the specified SiteBalRec by id.
	 */
	public void deleteById(long id);
	
	/**
	 * Update the results of this SiteBalRec to likely include total patients and total facilities.
	 */
	public void updateResults(SiteBalRec siteBalRec);
}
