package gov.va.cpss.dao;

import gov.va.cpss.model.bal.SiteBalance;

/**
 * Data Access Object interface for the *table name here* table.
 * 
 */
public interface SiteBalDAO {
	
	/**
	 * Return the specified SiteBalance by id.
	 */
	public SiteBalance getById(final long id);
	
	/**
	 * Return the specified SiteBalance by acctNum (icn number) and stationNum.
	 */
	public SiteBalance getByAcctNumAndStationNum(final long acntNum, final String stationNum);
	
	/**
	 * Save the specified SiteBalance to the database.
	 */
	public long save(SiteBalance siteBalance);
	/**
	 * Update the Site Balance Table PataAcntBalMsgId using MsgId - SendBill Job
	 * @param msgId
	 */
	public void updateSiteBalPatAcntBalMsgId(Long msgId);
	/**
	 * This Method is used to keep track of total records to process to ensure we do not miss the lass line of code.
	 * @return
	 */
	public Integer getTotalRecordsFromSiteBalToProcess();
}
