package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSSite;

/**
 * Data Access Object interface for the PSPatient table.
 * 
 * @author DNS  
 */
public interface PSPatientDAO {

	/**
	 * Save the specified PSPatient to the database.
	 * 
	 * @param patient
	 *            The patient to save. The id, createdBy, createdDate,
	 *            modifiedBy and modifiedDate properties will be updated to
	 *            match the database state after the insert.
	 * @return Auto-generated index ID of the entry in the database.
	 */
	public long save(PSPatient patient);

	/**
	 * Get the index of the last entry in the table.
	 * 
	 * @return Long representation of the last index or null if none.
	 */
	public Long getLastIndex();

	/**
	 * Get a list of all patient by the specified site.
	 */
	public List<PSPatient> getAllByPSSiteID(final PSSite psSite);

}
