package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.cbs.CBSSitePatient;
import gov.va.cpss.model.cbs.CBSStmt;

public interface CBSSitePatientDAO {

	/**
	 * Save the specified CBSSitePatient to the database.
	 * 
	 * @param patient
	 *            The patient to save. The id, createdBy, createdDate,
	 *            modifiedBy and modifiedDate properties will be updated to
	 *            match the database state after the insert.
	 * @return Auto-generated index ID of the entry in the database.
	 */
	public long save(CBSSitePatient patient);

	/**
	 * Batch save the nested CBSSitePatients contained within the list of
	 * CBSStmts to the database. Unlike the save() method, none of the fields
	 * populated by the database will be updated (id will not be set). The
	 * CBSSiteStmt record id is assumed to be populated.
	 * 
	 * @param statements
	 *            The list of statements to save
	 */
	void saveBatch(List<CBSStmt> statements);

	/**
	 * Get CBSSitePatient with the given id
	 * 
	 * @param id
	 *            id of the CBSSitePatient to get
	 * @return CBSSitePatient with given id
	 */
	CBSSitePatient get(long id);

	/**
	 * Batch update
	 * 
	 * @param inNewICNs
	 * @param inOldICNs
	 * @return numbers of updates
	 */
	public int[] batchUpdate(final String[] inNewICNs, final String[] inOldICNs);

}
