package gov.va.cpss.dao;

import java.util.List;
import java.util.Set;

import gov.va.cpss.model.cbs.CBSAccount;

/**
 * Data Access Object interface for the CBSAccount table.
 * 
 * @author DNS   
 */
public interface CBSAccountDAO {

	public Long getByICN(final String icn);

	public Long selectByICN(final String icn);
	
	public String selectICNById(final long id);

	public Long save(final String icn);

	/**
	 * Batch select
	 * 
	 * @param inICNs
	 * @return CBSAccounts
	 */
	public List<CBSAccount> batchSelect(final String[] inICNs);

	/**
	 * Batch insert and return List of CBSAccounts
	 * 
	 * @param inICNs
	 * @return List of new CBSAccounts
	 */
	public List<CBSAccount> batchInsertAndReturnCBSAccounts(Set<String> inICNs);

}
