package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.apps.APSReceivedSite;

/**
 * Data Access Object interface for the APSReceivedSite table.
 * 
 * Copyright DXC / VA
 * April 24, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSReceivedSiteDAO extends CBSSBaseDAO
{
    /**
     * Retrieve APSReceivedSite based on the facility number and statement data.
     * 
     * @param facilityNumber
     * @param statementYear
     * @return
     * 
     */
    public List<APSReceivedSite> select(final String facilityNumber, final int statementYear);

    /**
     * Update APSReceivedSite.
     * 
     * @param id
     * @param numOfMessages
     * @param statusId
     * @return
     * 
     */
    public int update(final long id, final long numOfMessages, final int statusId);

}
