package gov.va.cpss.dao;

import java.util.List;

import gov.va.cpss.model.ProcessStatus.Status;
import gov.va.cpss.model.apps.APSReceived;

/**
 * Data Access Object interface for the APSReceived table.
 * 
 * Copyright HPE / VA
 * October 20, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSReceivedDAO extends CBSSBaseDAO
{

	/**
	 * Update the results of the specified APSReceived object in the database.
	 * 
	 * @param apsReceived
	 */
	public int updateResults(final APSReceived apsReceived);

	/**
	 * Get list of APSReceived ID that have the specified status.
	 * 
	 * @return The list of ID
	 */
	public List<Long> getAPSReceivedIdListByStatus(final Status status);

}
