package gov.va.cpss.dao;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.ProcessStatus.Status;

import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSSite;

/**
 * Data Access Object interface for the APSPatient table.
 * 
 * Copyright HPE / VA
 * October 20, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSPatientDAO extends CBSSBaseDAO
{

	/**
	 * Get a list of all patient by the specified site.
	 */
	public List<APSPatient> getAllByAPSSite(final APSSite apsSite);

    /**
	 * Get paging lists of APSPatient with specific APSReceived status
     * 
     * @param page
     * @param pageSize
     * @param statementYear
     * @param status
     * 
     * @return one page list of APSPatient
	 */
	public List<APSPatient> getPatientsWithPaging(final int page, final int pageSize, final int statementYear, final Status status);

	/**
     * Batch insert / save without returning the generated keys.
     *
     * @param patients
     * @return int[] - an array of the number of rows affected by each statement
     * 
     */
    public int[] batchInsertWithoutKeys(final List<Entry<APSSite, APSPatient>> patients);
}
