package gov.va.cpss.dao;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.apps.APSDetails;
import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSSite;

/**
 * Data Access Object interface for the APSDetails table.
 * 
 * Copyright HPE / VA
 * October 20, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public interface APSDetailsDAO extends CBSSBaseDAO
{
    /**
     * Get the index of the last entry in the table.
     * @return Long representation of the last index or null if none.
     */
    //public Long getLastIndex();
    
    /**
	 * Get a list of all details by the specified site.
	 */
	public List<APSDetails> getAllByAPSSite(final APSSite apsSite);

    /**
     * Get a list of details by the specified patients.
     */
    public List<APSDetails> getByPatients(final List<APSPatient> patients);

    /**
     * Batch insert / save without returning the generated keys.
     *
     * @param detailsList
     * @return int[] - an array of the number of rows affected by each statement
     * 
     */
    public int[] batchInsertWithoutKeys(final List<Entry<APSPatient, APSDetails>> detailsList);
}
