package gov.va.cpss.ESAPI;

import static org.owasp.esapi.ESAPI.validator;

/**
 * ESAPI Validator class.
 * 
 * Copyright HPE / DXC / VA
 * 
 * @author Unknown
 * @version 1.0.0
 * 
 */
public final class EsapiValidator {

    /**
     * Private constructor.
     */
    private EsapiValidator() {
    }

    public static String validateStringInput(String input, EsapiValidationType type) {
        // Exit immediately if input is null
        if (input == null) {
            return null;
        }

        // Exit immediately if input is Empty
        if (input.length() < 1) {
            return "";
        }
        switch(type)
        {
        case CROSS_SITE_SCRIPTING_PERSISTENT:
            try {
                return validator().getValidInput("crossSiteScriptingPersistent", input, "crossSiteScriptingPersistent",
                        Integer.MAX_VALUE, false, false);
            } catch (Exception e) {
                throw new RuntimeException("Invalid characters found in input.  Cross Site Scripting: Persistent violation." + input);
            }  	
        case LOG_FORGING:
            try {
                return validator().getValidInput("logForging", input, "logForging",
                        Integer.MAX_VALUE, false, false);
            } catch (Exception e) {
                throw new RuntimeException("Invalid characters found in input. Log Forging violation." + input);
            }  	
        case SAFE_STRING:
            try {
                return validator().getValidInput("SafeString", input, "SafeString",
                        Integer.MAX_VALUE, false, false);
            } catch (Exception e) {
                throw new RuntimeException("Invalid characters found in input. Unsafe String violation.");
            }  	
        default: return null;
        } 
       
    }
}
