package gov.va.cpss.service;

import static org.junit.Assert.*;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.updatestation.Address;
import gov.va.cpss.model.updatestation.StationInfo;
import gov.va.cpss.model.updatestation.ZipCode;

/**
 * Unit test for StationInfoService class.
 *
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = {"/test-station-info.xml"})
@SuppressWarnings({"nls", "static-method"})
public class StationInfoServiceTest {
	
	@Autowired
	private StationInfoService service;
	
	@Test
	public void testBuildStationInfo() {
		
		final String line = "650  01PROVIDENCE VA MEDICAL CENTER (650)      004L0C/O AGENT CASHIER (04)                  830 CHALKSTONE AVE                                                              PROVIDENCE                              RI02908473430*029084734300*P1-866-601-6286                          PATIENT FINANCIAL SERVICES    1-866-601-6286                                    1-866-601-6286      ROOM 139 (04)                           830 CHALKSTONE AVE                                                              PROVIDENCE                              RI029084734                ATTN: GARY VON GEORGE                   PHONE: 401-273-7100                        005NORTH EAST CPAC                         1700 SOUTH LINCOLN AVE. BUILDING 2      LEBANON                                 PA17042      000-000-0000        CPAC-CONTACT-INFO             VETERANS AFFAIRS - NORTHEAST            PO BOX 530333                           ATLANTA                                 GA303530333          TAATFAFTDADDADAATATATTADATDFAATFDTTDDTAFFDFADAFTATDDDTFDTFFTTAFTF";
		
		final StationInfo expected = new StationInfo();
		expected.setStationNum("650");
		expected.setStationVisnNum("01");
		expected.setFacilityDesc("PROVIDENCE VA MEDICAL CENTER (650)");
		expected.setCycleNum("004");
		expected.setRemitFlag("L");
		expected.setPfssFlag("0");
		expected.setAddress(new Address("C/O AGENT CASHIER (04)                  ", "830 CHALKSTONE AVE", ""));
		//expected.setAddress(new Address("C/O AGENT CASHIER (04)                  830 CHALKSTONE AVE","",""));
		expected.setCity("PROVIDENCE");
		expected.setState("RI");
		expected.setZipCode(new ZipCode("02908", "4734", "30"));
		//expected.setZipCode(new ZipCode("02908473430", "", ""));
		expected.setBarCode("*029084734300*");
		expected.setTelephoneFlag("P");
		expected.setTelephoneNum1("1-866-601-6286");
		expected.setTelephoneNum2("");
		expected.setContactInfo1("PATIENT FINANCIAL SERVICES");
		expected.setDm2TelephoneNum("1-866-601-6286");
		expected.setContactInfo2("");
		expected.setTopTelephoneNum("1-866-601-6286");
		expected.setFedexAddress(new Address("ROOM 139 (04)                           ", "830 CHALKSTONE AVE", ""));
		//expected.setFedexAddress(new Address("ROOM 139 (04)                           830 CHALKSTONE AVE","",""));
		expected.setFedexCity("PROVIDENCE");
		expected.setFedexState("RI");
		expected.setFedexZipCode(new ZipCode("02908", "4734", ""));
		//expected.setFedexZipCode(new ZipCode("029084734","",""));
		expected.setFedexBarCode("");
		expected.setFedexContactInfo("ATTN: GARY VON GEORGE");
		expected.setFedexContactTelephoneNum("PHONE: 401-273-7100");
		expected.setCsStationFlag("");
		expected.setCpacNum("005");
		expected.setCpacName("NORTH EAST CPAC");
		expected.setCpacAddress1(new Address("1700 SOUTH LINCOLN AVE. BUILDING 2","",""));
		expected.setCpacCity("LEBANON");
		expected.setCpacState("PA");
		expected.setCpacZipCode(new ZipCode("17042","",""));
		expected.setCpacTelephoneNum("000-000-0000");
		expected.setCpacContactInfo("CPAC-CONTACT-INFO");
		expected.setCpacBoxName("VETERANS AFFAIRS - NORTHEAST");
		expected.setCpacBoxAddress1(new Address("PO BOX 530333","",""));
		expected.setCpacBoxCity("ATLANTA");
		expected.setCpacBoxState("GA");
		expected.setCpacBoxZipCode(new ZipCode("30353", "0333", ""));
		//expected.setCpacBoxZipCode(new ZipCode("303530333","",""));
		expected.setCpacBoxBarCode("TAATFAFTDADDADAATATATTADATDFAATFDTTDDTAFFDFADAFTATDDDTFDTFFTTAFTF");
		
		final StationInfo actual = this.service.buildStationInfo(line);
		
		assertEquals(expected.getStationNum(), actual.getStationNum());
		assertEquals(expected.getStationVisnNum(), actual.getStationVisnNum());
		assertEquals(expected.getFacilityDesc(), actual.getFacilityDesc());
		assertEquals(expected.getCycleNum(), actual.getCycleNum());
		assertEquals(expected.getRemitFlag(), actual.getRemitFlag());
		assertEquals(expected.getPfssFlag(), actual.getPfssFlag());
		assertEquals(expected.getAddress().getAddress1(), actual.getAddress().getAddress1());
		assertEquals(expected.getAddress().getAddress2(), actual.getAddress().getAddress2());
		assertEquals(expected.getCity(), actual.getCity());
		assertEquals(expected.getState(), actual.getState());
		assertEquals(expected.getZipCode().getZipCode1(), actual.getZipCode().getZipCode1());
		assertEquals(expected.getZipCode().getZipCode2(), actual.getZipCode().getZipCode2());
		assertEquals(expected.getZipCode().getZipCode3(), actual.getZipCode().getZipCode3());
		assertEquals(expected.getTelephoneFlag(), actual.getTelephoneFlag());
		assertEquals(expected.getTelephoneNum1(), actual.getTelephoneNum1());
		assertEquals(expected.getTelephoneNum2(), actual.getTelephoneNum2());
		assertEquals(expected.getContactInfo1(), actual.getContactInfo1());
		assertEquals(expected.getDm2TelephoneNum(), actual.getDm2TelephoneNum());
		assertEquals(expected.getContactInfo2(), actual.getContactInfo2());
		assertEquals(expected.getTopTelephoneNum(), actual.getTopTelephoneNum());
		assertEquals(expected.getFedexAddress().getAddress1(), actual.getFedexAddress().getAddress1());
		assertEquals(expected.getFedexAddress().getAddress2(), actual.getFedexAddress().getAddress2());
		assertEquals(expected.getFedexCity(), actual.getFedexCity());
		assertEquals(expected.getFedexState(), actual.getFedexState());
		assertEquals(expected.getFedexZipCode().getZipCode1(), actual.getFedexZipCode().getZipCode1());
		assertEquals(expected.getFedexZipCode().getZipCode2(), actual.getFedexZipCode().getZipCode2());
		assertEquals(expected.getFedexBarCode(), actual.getFedexBarCode());
		assertEquals(expected.getFedexContactInfo(), actual.getFedexContactInfo());
		assertEquals(expected.getFedexContactTelephoneNum(), actual.getFedexContactTelephoneNum());
		assertEquals(expected.getCsStationFlag(), actual.getCsStationFlag());
		assertEquals(expected.getCpacNum(), actual.getCpacNum());
		assertEquals(expected.getCpacName(), actual.getCpacName());
		assertEquals(expected.getCpacAddress1().getAddress1(), actual.getCpacAddress1().getAddress1());
		assertEquals(expected.getCpacAddress1().getAddress2(), actual.getCpacAddress1().getAddress2());
		assertEquals(expected.getCpacCity(), actual.getCpacCity());
		assertEquals(expected.getCpacState(), actual.getCpacState());
		assertEquals(expected.getCpacZipCode().getZipCode1(), actual.getCpacZipCode().getZipCode1());
		assertEquals(expected.getCpacZipCode().getZipCode2(), actual.getCpacZipCode().getZipCode2());
		assertEquals(expected.getCpacTelephoneNum(), actual.getCpacTelephoneNum());
		assertEquals(expected.getCpacContactInfo(), actual.getCpacContactInfo());
		assertEquals(expected.getCpacBoxName(), actual.getCpacBoxName());
		assertEquals(expected.getCpacBoxAddress1().getAddress1(), actual.getCpacBoxAddress1().getAddress1());
		assertEquals(expected.getCpacBoxCity(), actual.getCpacBoxCity());
		assertEquals(expected.getCpacBoxState(), actual.getCpacBoxState());
		assertEquals(expected.getCpacBoxZipCode().getZipCode1(), actual.getCpacBoxZipCode().getZipCode1());
		assertEquals(expected.getCpacBoxZipCode().getZipCode2(), actual.getCpacBoxZipCode().getZipCode2());
		assertEquals(expected.getCpacBoxBarCode(), actual.getCpacBoxBarCode());
		
	}
	
	@Test
	public void testGetStation() {
		
		assertNotNull(this.service.getStation("650"));
		
		assertEquals("TAATFAFTDADDADAATATATTADATDFAATFDTTDDTAFFDFADAFTATDDDTFDTFFTTAFTF", this.service.getStation("650").getCpacBoxBarCode());
		
	}

	@Test
    public void testGetStationUsingUtil()
    {    
        assertNotNull(StationInfoUtil.getStation("650"));
        
        assertEquals("TAATFAFTDADDADAATATATTADATDFAATFDTTDDTAFFDFADAFTATDDDTFDTFFTTAFTF", StationInfoUtil.getStation("650").getCpacBoxBarCode());
    }

    @Test
    public void testGetTotalNumberOfStationsUsingUtil()
    {    
        assertTrue(StationInfoUtil.getTotalNumberOfStations() > 0);
        
        assertEquals(StationInfoUtil.getTotalNumberOfStations(), 171);        
    }

    @Test
    public void testValidStationUsingUtil()
    {    
        assertTrue(StationInfoUtil.isValidStation("650"));
    }

    @Test
    public void testInvalidStationUsingUtil()
    {    
        assertFalse(StationInfoUtil.isValidStation("999"));
    }

}
