package gov.va.cpss.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.BatchJobDAO;
import gov.va.cpss.model.BatchJob;

/**
 * Test for  scheduling service for BatchJobDAO
 * 
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/cpss-batch.xml" })
public class SchedulingServiceIT {

    // Use Spring Autowired to easily access the DAO.
    @Autowired
    private BatchJobDAO batchJobDAO;

    @Test
    public final void testOne() {
        assertNotNull(batchJobDAO);

        BatchJob bj = batchJobDAO.getBatchJob(1);

        assertNotNull(bj);
        assertEquals("Process FPS Data", bj.getDescription());
    }
}
