package gov.va.cpss.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSSite;

/**
 * * Integration Unit Tests for PSPatient and PSSite
 * 
 *
 */
public class CbsServiceTestPatients {

	private Logger testPatientLogger;

	private final String DATE_FORMAT = "dd/MM/yyyy";

	// Site1/Patient1
	private PSSite psSite1 = new PSSite();
	private String psSite1Facility = "Site1";
	
	private PSPatient psPatient1 = new PSPatient();
	private long psPatient1Dfn = 100;
	private String psPatient1Icn = "ICN100";
	private String psPatient1DateString = "20/06/2016";

	
	// Site2/Patient2
	private PSSite psSite2 = new PSSite();
	private String psSite2Facility = "Site2";
	
	private PSPatient psPatient2 = new PSPatient(); // Date will be null to test
													// sort.
	private long psPatient2Dfn = 200;
	private String psPatient2Icn = "ICN200";
	
	
	// Site3/Patient3
	private PSSite psSite3 = new PSSite();
	private String psSite3Facility = "Site3";
	
	private PSPatient psPatient3 = new PSPatient();
	private long psPatient3Dfn = 300;
	private String psPatient3Icn = "ICN300";
	private String psPatient3DateString = "22/06/2016";
	
	
	// Site4/Patient4
	private PSSite psSite4 = new PSSite();
	private String psSite4Facility = "Site4";
	
	private PSPatient psPatient4 = new PSPatient(); // Date will be null to test
													// sort.
	private long psPatient4Dfn = 400;
	private String psPatient4Icn = "ICN400";
	
	
	// Site5/Patient5
	private PSSite psSite5 = new PSSite();
	private String psSite5Facility = "Site5";
	
	private PSPatient psPatient5 = new PSPatient();
	private String psPatient5DateString = "4/06/2016";
	private long psPatient5Dfn = 500;
	private String psPatient5Icn = "ICN500";
	
	
	// Site6/Patient6
	private PSSite psSite6 = new PSSite();
	private String psSite6Facility = "Site6";
	
	private PSPatient psPatient6 = new PSPatient();
	private String psPatient6DateString = "5/06/2016";
	private long psPatient6Dfn = 600;
	private String psPatient6Icn = "ICN600";

	public CbsServiceTestPatients() {

		testPatientLogger = Logger.getLogger(this.getClass().getCanonicalName());

		try {

			psSite1.setFacilityNum(psSite1Facility);
			psSite1.setStatementDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient1DateString));
			psSite1.setProcessDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient1DateString));
			psPatient1.setPsSite(psSite1);
			
			psPatient1.setDfnNumber(psPatient1Dfn);
			psPatient1.setIcnNumber(psPatient1Icn);
			
			psPatient1.setAmountDue(new Money(100.10, 20));
			psPatient1.setPrevBalance(new Money(10.10, 20));
			psPatient1.setTotalCharges(new Money(1.10, 20));
			psPatient1.setTotalCredits(new Money(11.11, 20));
			psPatient1.setNewBalance(new Money(10.11, 20));
			psPatient1.setLastBillPrepDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient1DateString));
			
			psSite2.setFacilityNum(psSite2Facility);
			psPatient2.setPsSite(psSite2);
			
			psPatient2.setDfnNumber(psPatient2Dfn);
			psPatient2.setIcnNumber(psPatient2Icn);
			
			psPatient2.setAmountDue(new Money(200.20, 20));
			psPatient2.setPrevBalance(new Money(20.20, 20));
			psPatient2.setTotalCharges(new Money(2.20, 20));
			psPatient2.setTotalCredits(new Money(22.22, 20));
			psPatient2.setNewBalance(new Money(20.22, 20));
			psPatient2.setLastBillPrepDate(null);

			psSite3.setFacilityNum(psSite3Facility);
			psSite3.setStatementDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient3DateString));
			psSite3.setProcessDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient3DateString));
			psPatient3.setPsSite(psSite3);
			
			psPatient3.setDfnNumber(psPatient3Dfn);
			psPatient3.setIcnNumber(psPatient3Icn);
			
			psPatient3.setAmountDue(new Money(300.30, 20));
			psPatient3.setPrevBalance(new Money(30.30, 20));
			psPatient3.setTotalCharges(new Money(3.30, 20));
			psPatient3.setTotalCredits(new Money(33.33, 20));
			psPatient3.setNewBalance(new Money(30.33, 20));
			psPatient3.setLastBillPrepDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient3DateString));

			psSite4.setFacilityNum(psSite4Facility);
			psPatient4.setPsSite(psSite4);
			
			psPatient4.setDfnNumber(psPatient4Dfn);
			psPatient4.setIcnNumber(psPatient4Icn);
			
			psPatient4.setAmountDue(new Money(400.40, 20));
			psPatient4.setPrevBalance(new Money(40.40, 20));
			psPatient4.setTotalCharges(new Money(4.40, 20));
			psPatient4.setTotalCredits(new Money(44.44, 20));
			psPatient4.setNewBalance(new Money(40.44, 20));
			psPatient4.setLastBillPrepDate(null);

			psSite5.setFacilityNum(psSite5Facility);
			psSite5.setStatementDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient5DateString));
			psSite5.setProcessDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient5DateString));
			psPatient5.setPsSite(psSite5);
			
			psPatient5.setDfnNumber(psPatient5Dfn);
			psPatient5.setIcnNumber(psPatient5Icn);
			
			psPatient5.setAmountDue(new Money(55.45, 20));
			psPatient5.setPrevBalance(new Money(14.45, 20));
			psPatient5.setTotalCharges(new Money(4.45, 20));
			psPatient5.setTotalCredits(new Money(3.45, 20));
			psPatient5.setNewBalance(new Money(0.45, 20));
			psPatient5.setLastBillPrepDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient5DateString));
			psPatient5.setAddressFlag(BooleanChar.Y);

			psSite6.setFacilityNum(psSite6Facility);
			psSite6.setStatementDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient6DateString));
			psSite6.setProcessDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient6DateString));
			psPatient6.setPsSite(psSite6);
			
			psPatient6.setDfnNumber(psPatient6Dfn);
			psPatient6.setIcnNumber(psPatient6Icn);
			
			psPatient6.setAmountDue(new Money(66.63, 20));
			psPatient6.setPrevBalance(new Money(16.12, 20));
			psPatient6.setTotalCharges(new Money(6.45, 20));
			psPatient6.setTotalCredits(new Money(9.45, 20));
			psPatient6.setNewBalance(new Money(0.06, 20));
			psPatient6.setLastBillPrepDate(new SimpleDateFormat(DATE_FORMAT).parse(psPatient6DateString));

		} catch (Exception e) {
			testPatientLogger.error(e.getMessage());
		}
	}

	public List<PSPatient> getTestPatientList() {

		List<PSPatient> patientL = new ArrayList<PSPatient>();

		patientL.add(psPatient1);
		patientL.add(psPatient2);
		patientL.add(psPatient3);
		patientL.add(psPatient4);

		return patientL;
	}

	public List<PSPatient> getTestPatientList2() {

		List<PSPatient> patientL = new ArrayList<PSPatient>();

		patientL.add(psPatient5);
		patientL.add(psPatient6);

		return patientL;
	}

	public List<PSPatient> getArTestPatientList() {

		List<PSPatient> patientL = new ArrayList<PSPatient>();

		PSPatient psPatient1Ar = psPatient1;
		psPatient1Ar.setAddressFlag(BooleanChar.Y);

		patientL.add(psPatient1Ar);
		patientL.add(psPatient2);
		patientL.add(psPatient3);
		patientL.add(psPatient4);

		return patientL;
	}

	public List<PSPatient> getMultipleArTestPatientList() {

		List<PSPatient> patientL = new ArrayList<PSPatient>();

		PSPatient psPatient1Ar = psPatient1;
		psPatient1Ar.setAddressFlag(BooleanChar.Y);

		PSPatient psPatient2Ar = psPatient2;
		psPatient2Ar.setAddressFlag(BooleanChar.Y);

		patientL.add(psPatient1Ar);
		patientL.add(psPatient2Ar);
		patientL.add(psPatient3);
		patientL.add(psPatient4);

		return patientL;
	}

	public PSPatient getPatient1() {
		return psPatient1;
	}

	public PSPatient getPatient2() {
		return psPatient2;
	}

	public PSPatient getPatient3() {
		return psPatient3;
	}

	public PSPatient getPatient4() {
		return psPatient4;
	}

	public PSPatient getPatient5() {
		return psPatient5;
	}

	public PSPatient getPatient6() {
		return psPatient6;
	}

}
