package gov.va.cpss.model;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.UnknownFormatConversionException;

import org.junit.Test;

/**
 * Test for BooleanChar
 * 
 *
 */
public class BooleanCharTest {
	
	@Test
	public final void testBooleanChar() {
		BooleanChar Y = BooleanChar.Y;
		BooleanChar N = BooleanChar.N;
		
		assertTrue(Y != N);
		
		assertEquals(Y.toString(), "Y");
		assertEquals(N.toString(), "N");
		
		assertEquals(Y.toInt(), "1");
		assertEquals(N.toInt(), "0");
		
		assertTrue(Y.isTrue());
		assertFalse(N.isTrue());
		
		assertEquals(Y.getCharValue(), 'Y');
		assertEquals(N.getCharValue(), 'N');
		
		assertEquals(Y.getIntValue(), '1');
		assertEquals(N.getIntValue(), '0');
		
	}
	
	@Test
	public final void testFrom() {
		assertEquals(BooleanChar.from('Y'), BooleanChar.Y);
		assertEquals(BooleanChar.from('y'), BooleanChar.Y);
		assertEquals(BooleanChar.from("Y"), BooleanChar.Y);
		assertEquals(BooleanChar.from("y"), BooleanChar.Y);
		assertEquals(BooleanChar.from("1"), BooleanChar.Y);
		
		assertEquals(BooleanChar.from('N'), BooleanChar.N);
		assertEquals(BooleanChar.from('n'), BooleanChar.N);
		assertEquals(BooleanChar.from("N"), BooleanChar.N);
		assertEquals(BooleanChar.from("n"), BooleanChar.N);
		assertEquals(BooleanChar.from("0"), BooleanChar.N);
		
		assertEquals(BooleanChar.from("Yxxx"), BooleanChar.Y);
		assertEquals(BooleanChar.from("yxxx"), BooleanChar.Y);
		assertEquals(BooleanChar.from("1xxx"), BooleanChar.Y);
		
		assertEquals(BooleanChar.from("Nxxx"), BooleanChar.N);
		assertEquals(BooleanChar.from("nxxx"), BooleanChar.N);
		assertEquals(BooleanChar.from("0xxx"), BooleanChar.N);
	}
	
	@Test(expected=UnknownFormatConversionException.class)
	public final void testNullString() {
		BooleanChar.from((String)null);
	}

	@Test(expected=UnknownFormatConversionException.class)
	public final void testWrongString() {
		BooleanChar.from("A");
	}

	@Test(expected=UnknownFormatConversionException.class)
	public final void testWrongChar() {
		BooleanChar.from('A');
	}

}
