package gov.va.cpss.mirth;

import static org.junit.Assert.assertTrue;

/** 
 * Utility class to test Mirth utility
 * 
 *
 */
class MirthTestUtils {

	public static final long WAIT_TIME_MAX_MILLIS = 60000L;

	public static final long WAIT_TIME_INC_MILLIS = 1000L;

	public static long waitForCompletion(final long maxWaitTimeMillis, final CompletionIndicator completionIndicator)
			throws InterruptedException {
		long waitTimeMillis = 0L;
	
		while (!completionIndicator.complete() && (waitTimeMillis < maxWaitTimeMillis)) {
			try {
				Thread.sleep(WAIT_TIME_INC_MILLIS);
			} catch (InterruptedException e) {
				e.printStackTrace();
				throw e;
			}
	
			waitTimeMillis += WAIT_TIME_INC_MILLIS;
		}
	
		assertTrue(completionIndicator.complete());
		return waitTimeMillis;
	}

}
