package gov.va.cpss.job.loadbill;

import java.io.File;

import org.springframework.batch.core.JobExecution;

import gov.va.cpss.job.LoadBillDataJob;
import gov.va.cpss.model.BatchJob;
import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.bal.SiteBalRec;

/**
 * Test Wrapper for LoadBillDataJob
 * 
 * @author Lesley Brown
 *
 */
public class TestLoadBillDataJob extends LoadBillDataJob {
	
	private int batchRunId;

	public int getBatchRunId() {
		return batchRunId;
	}
	
	public void setFilePath(final String fp) {
		ClassLoader classLoader = this.getClass().getClassLoader();
		File file = new File(classLoader.getResource(fp).getFile());
		this.filename = file.getAbsolutePath();
	}

	/**
	 * Sets up the BachJob and BatchRun context then runs the LoadBillDataJob.
	 * 
	 * @return Boolean value indicating if successful or not.
	 */
	public boolean testJob(final boolean bypassFtp) {

		boolean successful = false;

		resetMessages();
		BatchJob bj = batchService.getBatchJobByName(name);
		BatchRun bR = batchService.startRun(bj.getId());

		if (bR != null) {
			batchRunId = bR.getId();

			jobLogger.info("Job " + name + " Started: " + bR.getStartDate());

			if (getJob() == null) {
				jobLogger.error("Job batch is null");
				errorRun(bR);
			} else if (bypassFtp) {
				SiteBalRec received = initializeJob(bR.getId());
				JobExecution execution = executeJob(getJob(), getParameters(received));
				successful = loadBillService.endProcessLoadBillDataJob(execution, received);
				//successful = runJobBypassFtp(bR, getJob());
				if(successful) {
					completeRun(bR);
				} else {
					errorRun(bR);
				}
			} else if (runJob(bR, getJob())) {
				completeRun(bR);
				successful = true;
			} else {
				errorRun(bR);
			}
			
			jobLogger.info(buildEmailMessage(bj, bR));

		} else {
			final String errorMessage = "Problem Starting Job " + name;
			jobLogger.error(errorMessage);
		}
		
		return successful;
	}
	
	public boolean testJob() {
		return testJob(false);
	}

}
