package gov.va.cpss.job;

import org.apache.log4j.Logger;

import gov.va.cpss.model.BatchJob;
import gov.va.cpss.model.BatchRun;

/**
 * Test Wrapper for SendCBSJob
 * 
 * @author Brad Pickle
 *
 */
public class SendCBSJobTestWrapper extends SendCBSJob {

	protected Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
	
	private int batchRunId;

	private String serverTargetDirectory;

	private String tempFilenamePostfix;

	public int getBatchRunId() {
		return batchRunId;
	}

	public String getServerTargetDirectory() {
		return serverTargetDirectory;
	}

	public void setServerTargetDirectory(String serverTargetDirectory) {
		this.serverTargetDirectory = serverTargetDirectory;
	}

	public String getTempFilenamePostfix() {
		return tempFilenamePostfix;
	}

	public void setTempFilenamePostfix(String tempFilenamePostfix) {
		this.tempFilenamePostfix = tempFilenamePostfix;
	}

	/**
	 * Sets up the BachJob and BatchRun context then runs the SendCBSJob.
	 * 
	 * @return Boolean value indicating if successful or not.
	 */
	public boolean testJob() {

		boolean successful = false;

		resetMessages();
		BatchJob bj = batchService.getBatchJobByName(name);
		BatchRun bR = batchService.startRun(bj.getId());

		if (bR != null) {
			batchRunId = bR.getId();

			jobLogger.info("Job " + name + " Started: " + bR.getStartDate());

			if (getJob() == null) {
				jobLogger.error("Job batch is null");
				errorRun(bR);
			} else if (runJob(bR, getJob())) {
				completeRun(bR);
				successful = true;
			} else {
				errorRun(bR);
			}

			jobLogger.info(buildEmailMessage(bj, bR));

		} else {
			final String errorMessage = "Problem Starting Job " + name;
			jobLogger.error(errorMessage);
		}

		return successful;
	}

}
