package gov.va.cpss.jasper;

import static org.junit.Assume.assumeTrue;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

/**
 * Test for ConsolidatedPatientStatement class.
 * 
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml" })
public class ConsolidatedPatientStatementTest {
	

	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	/**
	 * Only run these tests if property is set to run integration test.
	 */
	@Before
    public final void beforeTest() {
    	assumeTrue(runIntegrationTest);
    }
	
	@Test
	public final void testSimple508() {

		String outputFile = "CpssPrototypeSimplePrototype.pdf";

		generateSimpleConsolidatedPatientStatement(outputFile, false);
	}

	@Test
	public final void testLong508() {

		String outputFile = "CpssPrototypeLongPrototype.pdf";

		generateLongConsolidatedPatientStatement(outputFile, false);
	}
	
	@Test
	public final void testLong508b() {

		String outputFile = "CpssPrototypeLongPrototype.pdf";

		generateLongConsolidatedPatientStatementb(outputFile, false);
	}
	
	@Test
	public final void testLong508c() {

		String outputFile = "CpssPrototypeLongPrototype.pdf";

		generateLongConsolidatedPatientStatementc(outputFile, false);
	}
	
//	@Test
//	public final void testLong508d() {
//
//		String outputFile = "CpssPrototypeLongPrototyped.pdf";
//
//		generateLongConsolidatedPatientStatementd(outputFile, false);
//	}
	
	@Test
	public final void testLong508e() {

		String outputFile = "CpssPrototypePrototypeDemo2.pdf";

		generateLongConsolidatedPatientStatemente(outputFile, false);
	}

	@Test
	public final void testPaymentDue() {

		final String outputFile = "CpssPrototypeOutputPaymentDue.pdf";

		generateExampleConsolidatedPatientStatement(outputFile, true);
	}

	@Test
	public final void testNoPaymentDue() {

		String outputFile = "CpssPrototypeOutputNoPaymentDue.pdf";

		generateExampleConsolidatedPatientStatement(outputFile, false);
	}

	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateSimpleConsolidatedPatientStatement(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String siteTitleSubreportJasper = "CpsSiteTitleSubreport.jrxml";
		String siteTotalSubreportJasper = "CpsSiteTotalSubreport.jrxml";
		String siteDelimiterSubreportJasper = "CpsSiteDelimiterSubreport.jrxml";
		String siteTrailingSpaceSubreportJasper = "CpsSiteTrailingSpaceSubreport.jrxml";
		String siteFillerSpaceSubreportJasper = "CpsSiteFillerSpaceSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";
		
		try {

			// Get InputStream of main report file.
			ClassLoader classLoader = this.getClass().getClassLoader();
			// Get InputStream of main report file.
;
			
			InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
			InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
			InputStream siteTitleSubreportIS =classLoader.getResourceAsStream(siteTitleSubreportJasper);
			InputStream siteTotalSubreportIS =classLoader.getResourceAsStream(siteTotalSubreportJasper);
			InputStream siteDelimiterSubreportIS =classLoader.getResourceAsStream(siteDelimiterSubreportJasper);
			InputStream siteTrailingSpaceSubreportIS =classLoader.getResourceAsStream(siteTrailingSpaceSubreportJasper);
			InputStream siteFillerSpaceSubreportIS =classLoader.getResourceAsStream(siteFillerSpaceSubreportJasper);
			InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);

			
			// Load the main report file to an object to populate
			// dynamically.
			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
			JasperReport siteTitleSubreport = JasperCompileManager.compileReport(siteTitleSubreportIS);
			JasperReport siteTotalSubreport = JasperCompileManager.compileReport(siteTotalSubreportIS);
			JasperReport siteDelimiterSubreport = JasperCompileManager.compileReport(siteDelimiterSubreportIS);
			JasperReport siteTrailingSpaceSubreport = JasperCompileManager.compileReport(siteTrailingSpaceSubreportIS);
			JasperReport siteFillerSpaceSubreport = JasperCompileManager.compileReport(siteFillerSpaceSubreportIS);
			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createSimple();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTitleSubreportParameter",
					siteTitleSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteDelimiterSubreportParameter",
					siteDelimiterSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteFillerSpaceSubreportParameter",
					siteFillerSpaceSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTotalSubreportParameter",
					siteTotalSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTrailingSpaceSubreportParameter",
					siteTrailingSpaceSubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}

	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateLongConsolidatedPatientStatement(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";

		try {

			// Get InputStream of main report file.
			ClassLoader classLoader = this.getClass().getClassLoader();
			// Main Report

			InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
			InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
			InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);
			// load the main report file to an object to populate
			// dynamically.
			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);

			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createLong();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			
//			CustomVerticalFiller customVerticalFiller = new CustomVerticalFiller(DefaultJasperReportsContext.getInstance(), mainReport);
//			JasperPrint jasperPrint = customVerticalFiller.fill(mainReportValueParametersM, siteStatementCollectionDataSource);
			
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}
	
	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateLongConsolidatedPatientStatementb(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";
		
		try {

			// Get InputStream of main report file.
			ClassLoader classLoader = this.getClass().getClassLoader();
			// Get InputStream of main report file.
;
			
			InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
			InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
			InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);

			
			// Load the main report file to an object to populate
			// dynamically.
			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
			
			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createLong();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			
//			CustomVerticalFiller customVerticalFiller = new CustomVerticalFiller(DefaultJasperReportsContext.getInstance(), mainReport);
//			JasperPrint jasperPrint = customVerticalFiller.fill(mainReportValueParametersM, siteStatementCollectionDataSource);
			
			
			siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createLong();
			siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);
			JasperPrint jasperPrint2 = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			
			
			List<JRPrintPage> pages = jasperPrint2.getPages();
			System.out.println("MERGE PAGES!: " + pages.size());
			for (int i = 0; i < pages.size(); ++i) {
				System.out.println("ADDING PAGE: " + i);
				JRPrintPage p = pages.get(i);
				jasperPrint.addPage(p);
			}
			
			
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}
	
	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateLongConsolidatedPatientStatementc(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String siteTitleSubreportJasper = "CpsSiteTitleSubreport.jrxml";
		String siteTotalSubreportJasper = "CpsSiteTotalSubreport.jrxml";
		String siteDelimiterSubreportJasper = "CpsSiteDelimiterSubreport.jrxml";
		String siteTrailingSpaceSubreportJasper = "CpsSiteTrailingSpaceSubreport.jrxml";
		String siteFillerSpaceSubreportJasper = "CpsSiteFillerSpaceSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";
		String lateStmtSubreportJasper = "CpsSiteLateStmtSubreport.jrxml";
		
		try {

			// Get InputStream of main report file.
			ClassLoader classLoader = this.getClass().getClassLoader();
			// Get InputStream of main report file.
;
			
			InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
			InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
			InputStream siteTitleSubreportIS =classLoader.getResourceAsStream(siteTitleSubreportJasper);
			InputStream siteTotalSubreportIS =classLoader.getResourceAsStream(siteTotalSubreportJasper);
			InputStream siteDelimiterSubreportIS =classLoader.getResourceAsStream(siteDelimiterSubreportJasper);
			InputStream siteTrailingSpaceSubreportIS =classLoader.getResourceAsStream(siteTrailingSpaceSubreportJasper);
			InputStream siteFillerSpaceSubreportIS =classLoader.getResourceAsStream(siteFillerSpaceSubreportJasper);
			InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);
			InputStream lateStmtSubreportIS =classLoader.getResourceAsStream(lateStmtSubreportJasper);

			
			// Load the main report file to an object to populate
			// dynamically.
			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
			JasperReport siteTitleSubreport = JasperCompileManager.compileReport(siteTitleSubreportIS);
			JasperReport siteTotalSubreport = JasperCompileManager.compileReport(siteTotalSubreportIS);
			JasperReport siteDelimiterSubreport = JasperCompileManager.compileReport(siteDelimiterSubreportIS);
			JasperReport siteTrailingSpaceSubreport = JasperCompileManager.compileReport(siteTrailingSpaceSubreportIS);
			JasperReport siteFillerSpaceSubreport = JasperCompileManager.compileReport(siteFillerSpaceSubreportIS);
			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
			JasperReport lateStmtSubreport = JasperCompileManager.compileReport(lateStmtSubreportIS);

			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createLong();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTitleSubreportParameter",
					siteTitleSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteDelimiterSubreportParameter",
					siteDelimiterSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteFillerSpaceSubreportParameter",
					siteFillerSpaceSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTotalSubreportParameter",
					siteTotalSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTrailingSpaceSubreportParameter",
					siteTrailingSpaceSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteLateStmtSubreportParameter",
					lateStmtSubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			
//			CustomVerticalFiller customVerticalFiller = new CustomVerticalFiller(DefaultJasperReportsContext.getInstance(), mainReport);
//			JasperPrint jasperPrint = customVerticalFiller.fill(mainReportValueParametersM, siteStatementCollectionDataSource);
			
			
			siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.createLong();
			siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);
//			JasperPrint jasperPrint2 = JasperFillManager.fillReport(extensionReport, mainReportValueParametersM,
//					siteStatementCollectionDataSource);
//			
			
			int jasperPrintLength = jasperPrint.getPages().size();
			for (int i = jasperPrintLength - 1; i > 0; --i) {
				jasperPrint.removePage(i);
			}
			
//			List<JRPrintPage> pages = jasperPrint2.getPages();
//			System.out.println("MERGE PAGES!: " + pages.size());
//			for (int i = 1; i < pages.size(); ++i) {
//				System.out.println("ADDING PAGE: " + i);
//				JRPrintPage p = pages.get(i);
//				jasperPrint.addPage(p);
//			}
			
			
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}

	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
//	private void generateLongConsolidatedPatientStatementd(final String outputFile, final boolean paymentDueFlag) {
//
//		String mainReportJasper = "ConsolidatedPatientStatementCouponPage.jrxml";
//		String extensionReportJasper = "ConsolidatedPatientStatementExtensionPage.jrxml";
//		String detailSubreportJasper = "ConsolidatedPatientStatementSiteSubreport.jrxml";
//		String detailEntrySubreportJasper = "ConsolidatedPatientStatementSiteEntrySubreport.jrxml";
//
//		try {
//
//			// Get InputStream of main report file.
//			ClassLoader classLoader = this.getClass().getClassLoader();
//			// Main Report
//			File mainReportFilePath = new File(
//					new File(classLoader.getResource(mainReportJasper).getFile()).getAbsolutePath());
//			InputStream mainReportIS = new FileInputStream(mainReportFilePath);
//			// Extension Report
//			File extensionReportFilePath = new File(
//					new File(classLoader.getResource(extensionReportJasper).getFile()).getAbsolutePath());
//			InputStream extensionReportIS = new FileInputStream(extensionReportFilePath);
//			// Detail Subreport
//			File detailSubreportFilePath = new File(
//					new File(classLoader.getResource(detailSubreportJasper).getFile()).getAbsolutePath());
//			InputStream detailSubreportIS = new FileInputStream(detailSubreportFilePath);
//			// Detail Entry Sub-Subreport
//			File detailEntrySubreportFilePath = new File(
//					new File(classLoader.getResource(detailEntrySubreportJasper).getFile()).getAbsolutePath());
//			InputStream detailEntrySubreportIS = new FileInputStream(detailEntrySubreportFilePath);
//
//			// Compile the main report file to an object to populate
//			// dynamically.
//			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
//			JasperReport extensionReport = JasperCompileManager.compileReport(extensionReportIS);
//			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
//			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
//
//			// Create a data source to use as inputs to populate the site
//			// statement sub report portion of the PDF.
//			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
//					.create2();
//			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
//					siteStatementCollectionBeanL);
//
//			System.out.println("FIRST SIZE: " + siteStatementCollectionBeanL.get(0).size());
//			List<PdfSiteStatementBean> tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL) {
//				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
//			// Filter the number of lines in the first page.
//			// 1) Site
//			// 2-x) Description
//			// n-1) Dashed Line
//			// n) Total
//			
//			// If we want n lines then x = n - 3
//			int n = 15;
////			int x = n - 3;
//			PdfSiteStatementCollectionBean collectionBean = siteStatementCollectionBeanL.get(0);
//			if (collectionBean.size() > n) {
//				collectionBean.truncate(n);
//			}
//			
//			System.out.println("FIRST SIZE2: " + siteStatementCollectionBeanL.get(0).size());
//			List<PdfSiteStatementBean> tL2 = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL2) {
//				System.out.println("   PdfSiteStatementBean.size2 = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
//			
//			// Create a parameter map to use as inputs to populate the global
//			// portion of the PDF.
//			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);
//
//			// Add the subreports as parameters.
//			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
//			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
//					detailEntrySubreport);
//
//			// Dynamically fill the report with the parameter map and sub report
//			// collection data source.
//			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
//					siteStatementCollectionDataSource);
//			
//
//			// vvvv Extension Pages
//			
//			siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
//					.create2();
//			
//			System.out.println("SECOND SIZE: " + siteStatementCollectionBeanL.get(0).size());
//			tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL) {
//				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
////			int n = 15;
////			int x = n - 3;
//			collectionBean = siteStatementCollectionBeanL.get(0);
//			if (collectionBean.size() > n) {
//				collectionBean.cut(n);
//			}
//			
//			System.out.println("SECOND SIZE2: " + siteStatementCollectionBeanL.get(0).size());
//			tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL) {
//				System.out.println("   PdfSiteStatementBean.size2 = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
//			siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
//					siteStatementCollectionBeanL);
//			JasperPrint jasperPrint2 = JasperFillManager.fillReport(extensionReport, mainReportValueParametersM,
//					siteStatementCollectionDataSource);
//			
//			
//			int jasperPrintLength = jasperPrint.getPages().size();
//			for (int i = jasperPrintLength - 1; i > 0; --i) {
//				jasperPrint.removePage(i);
//			}
//			
//			List<JRPrintPage> pages = jasperPrint2.getPages();
//			System.out.println("MERGE PAGES!: " + pages.size());
//			for (int i = 0; i < pages.size(); ++i) {
//				System.out.println("ADDING PAGE: " + i);
//				JRPrintPage p = pages.get(i);
//				jasperPrint.addPage(p);
//			}
//			
//			// ^^^^ Extension Pages
//			
//			System.out.println("AFTER Generation: " + outputFile);
//
//			// Export the dynamically filled report to disk.
//			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);
//
//		} catch (JRException e) {
//
//			System.out.println(e.getMessage());
//
//		} catch (FileNotFoundException e) {
//
//			System.out.println(e.getMessage());
//
//		}
//	}
	
	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateLongConsolidatedPatientStatemente(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String siteTitleSubreportJasper = "CpsSiteTitleSubreport.jrxml";
		String siteTotalSubreportJasper = "CpsSiteTotalSubreport.jrxml";
		String siteDelimiterSubreportJasper = "CpsSiteDelimiterSubreport.jrxml";
		String siteTrailingSpaceSubreportJasper = "CpsSiteTrailingSpaceSubreport.jrxml";
		String siteFillerSpaceSubreportJasper = "CpsSiteFillerSpaceSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";
		String siteLateStmtJasper = "CpsSiteLateStmtSubreport.jrxml";
		
		try {

				// Get InputStream of main report file.
				ClassLoader classLoader = this.getClass().getClassLoader();
				// Get InputStream of main report file.
	;
				
				InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
				InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
				InputStream siteTitleSubreportIS =classLoader.getResourceAsStream(siteTitleSubreportJasper);
				InputStream siteTotalSubreportIS =classLoader.getResourceAsStream(siteTotalSubreportJasper);
				InputStream siteDelimiterSubreportIS =classLoader.getResourceAsStream(siteDelimiterSubreportJasper);
				InputStream siteTrailingSpaceSubreportIS =classLoader.getResourceAsStream(siteTrailingSpaceSubreportJasper);
				InputStream siteFillerSpaceSubreportIS =classLoader.getResourceAsStream(siteFillerSpaceSubreportJasper);
				InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);
				InputStream lateStmtSubreportIS =classLoader.getResourceAsStream(siteLateStmtJasper);
				
				// Load the main report file to an object to populate
				// dynamically.
				JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
				JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
				JasperReport siteTitleSubreport = JasperCompileManager.compileReport(siteTitleSubreportIS);
				JasperReport siteTotalSubreport = JasperCompileManager.compileReport(siteTotalSubreportIS);
				JasperReport siteDelimiterSubreport = JasperCompileManager.compileReport(siteDelimiterSubreportIS);
				JasperReport siteTrailingSpaceSubreport = JasperCompileManager.compileReport(siteTrailingSpaceSubreportIS);
				JasperReport siteFillerSpaceSubreport = JasperCompileManager.compileReport(siteFillerSpaceSubreportIS);
				JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
				JasperReport lateStmtSubreport = JasperCompileManager.compileReport(lateStmtSubreportIS);
			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.create2();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			
			System.out.println("FIRST SIZE: " + siteStatementCollectionBeanL.get(0).getSiteStatementL().size());
			List<PdfSiteStatementBean> tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
			for (PdfSiteStatementBean b : tL) {
				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
			}
			
			// Filter the number of lines in the first page.
			// 1) Site
			// 2-x) Description
			// n-1) Dashed Line
			// n) Total
			
			// If we want n lines then x = n - 3
			int n = 22;
//			int x = n - 3;
			int m = 38; // extension page length
			
			// Split!
			siteStatementCollectionBeanL.get(0).split(n);
			siteStatementCollectionBeanL.get(0).addFillerSpace(n, m);
			
			
//			PdfSiteStatementCollectionBean collectionBean = siteStatementCollectionBeanL.get(0);
//			if (collectionBean.size() > n) {
//				collectionBean.truncate(n);
//			}
			
			System.out.println("SPLIT COUPON SIZE: " + siteStatementCollectionBeanL.get(0).couponSize());
			List<PdfSiteStatementBean> tL2 = siteStatementCollectionBeanL.get(0).getSiteStatementCouponPageL();
			for (PdfSiteStatementBean b : tL2) {
				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
			}
			
			System.out.println("SPLIT EXTENSION SIZE: " + siteStatementCollectionBeanL.get(0).extensionSize());
			tL = siteStatementCollectionBeanL.get(0).getSiteStatementExtensionPageL();
			for (PdfSiteStatementBean b : tL) {
				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
			}
			
			
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildSimpleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTitleSubreportParameter",
					siteTitleSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteDelimiterSubreportParameter",
					siteDelimiterSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteFillerSpaceSubreportParameter",
					siteFillerSpaceSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTotalSubreportParameter",
					siteTotalSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteTrailingSpaceSubreportParameter",
					siteTrailingSpaceSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteLateStmtSubreportParameter",
					lateStmtSubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			

			//Extension Pages
			
//			siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
//					.create2();
//			
//			System.out.println("SECOND SIZE: " + siteStatementCollectionBeanL.get(0).size());
//			tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL) {
//				System.out.println("   PdfSiteStatementBean.size = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
////			int n = 15;
////			int x = n - 3;
//			collectionBean = siteStatementCollectionBeanL.get(0);
//			if (collectionBean.size() > n) {
//				collectionBean.cut(n);
//			}
//			
//			System.out.println("SECOND SIZE2: " + siteStatementCollectionBeanL.get(0).size());
//			tL = siteStatementCollectionBeanL.get(0).getSiteStatementL();
//			for (PdfSiteStatementBean b : tL) {
//				System.out.println("   PdfSiteStatementBean.size2 = " + b.size() + "(" + b.getRecords().size() + ")");
//			}
//			
//			siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
//					siteStatementCollectionBeanL);
//			JasperPrint jasperPrint2 = JasperFillManager.fillReport(extensionReport, mainReportValueParametersM,
//					siteStatementCollectionDataSource);
//			
//			
//			int jasperPrintLength = jasperPrint.getPages().size();
//			for (int i = jasperPrintLength - 1; i > 0; --i) {
//				jasperPrint.removePage(i);
//			}
//			
//			List<JRPrintPage> pages = jasperPrint2.getPages();
//			System.out.println("MERGE PAGES!: " + pages.size());
//			for (int i = 0; i < pages.size(); ++i) {
//				System.out.println("ADDING PAGE: " + i);
//				JRPrintPage p = pages.get(i);
//				jasperPrint.addPage(p);
//			}
//			
			// ^^^^ Extension Pages
			
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}

	/**
	 * Generate an example consolidated patient statement.
	 * 
	 * @param outputFile
	 *            The name of the output file.
	 * @param paymentDueFlag
	 *            Flag indicating if should generate a payment due or no payment
	 *            due example.
	 */
	private void generateExampleConsolidatedPatientStatement(final String outputFile, final boolean paymentDueFlag) {

		String mainReportJasper = "ConsolidatedPatientStatement.jrxml";
		String detailSubreportJasper = "CpsSiteSubreport.jrxml";
		String detailEntrySubreportJasper = "CpsSiteEntrySubreport.jrxml";
		
		try {

			// Get InputStream of main report file.
			ClassLoader classLoader = this.getClass().getClassLoader();
			// Get InputStream of main report file.
;
			
			InputStream mainReportIS =classLoader.getResourceAsStream(mainReportJasper);
			InputStream detailSubreportIS =classLoader.getResourceAsStream(detailSubreportJasper);
			InputStream detailEntrySubreportIS =classLoader.getResourceAsStream(detailEntrySubreportJasper);

			
			// Load the main report file to an object to populate
			// dynamically.
			JasperReport mainReport = JasperCompileManager.compileReport(mainReportIS);
			JasperReport detailSubreport = JasperCompileManager.compileReport(detailSubreportIS);
			JasperReport detailEntrySubreport = JasperCompileManager.compileReport(detailEntrySubreportIS);
			
			// Create a data source to use as inputs to populate the site
			// statement sub report portion of the PDF.
			List<PdfSiteStatementCollectionBean> siteStatementCollectionBeanL = TestPdfSiteStatementCollectionBeanFactory
					.create();
			JRBeanCollectionDataSource siteStatementCollectionDataSource = new JRBeanCollectionDataSource(
					siteStatementCollectionBeanL);

			InputStream vaLogoIs =classLoader.getResourceAsStream("7_VA_1COLOR_HORIZONT_12C9F6.jpg");
			InputStream checkboxIs =classLoader.getResourceAsStream("checkbox.png");
			Image vaLogo = ImageIO.read(vaLogoIs);
			Image checkbox = ImageIO.read(checkboxIs);
			
			// Create a parameter map to use as inputs to populate the global
			// portion of the PDF.
			Map<String, Object> mainReportValueParametersM = buildExampleParameterValueMap(paymentDueFlag);

			// Add the subreports as parameters.
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteSubreportParameter", detailSubreport);
			mainReportValueParametersM.put("ConsolidatedPatientStatementSiteEntrySubreportParameter",
					detailEntrySubreport);
			mainReportValueParametersM.put("vaLogo",vaLogo);
			mainReportValueParametersM.put("checkbox",checkbox);
			// Dynamically fill the report with the parameter map and sub report
			// collection data source.
			JasperPrint jasperPrint = JasperFillManager.fillReport(mainReport, mainReportValueParametersM,
					siteStatementCollectionDataSource);
			System.out.println("AFTER Generation: " + outputFile);

			// Export the dynamically filled report to disk.
			JasperExportManager.exportReportToPdfFile(jasperPrint, outputFile);

		} catch (JRException e) {

			System.out.println(e.getMessage());

		} catch (IOException e) {
			System.out.println(e.getMessage());
		}

	}

	/**
	 * Build an example parameter value map for the global portion of the PDF.
	 * 
	 * @param paymentDueFlag
	 *            Flag indicating if the parameters should mimic a payment due
	 *            statement.
	 * @return Map of report parameters.
	 */
	private Map<String, Object> buildSimpleParameterValueMap(final boolean paymentDueFlag) {

		Map<String, Object> reportValueM = buildSimpleMap();

		if (paymentDueFlag) {
			appendPaymentDueFields(reportValueM);
		} else {
			appendNoPaymentDueFields(reportValueM);
		}

		return reportValueM;
	}

	/**
	 * Build an example parameter value map for the global portion of the PDF.
	 * 
	 * @param paymentDueFlag
	 *            Flag indicating if the parameters should mimic a payment due
	 *            statement.
	 * @return Map of report parameters.
	 */
	private Map<String, Object> buildExampleParameterValueMap(final boolean paymentDueFlag) {

		Map<String, Object> reportValueM = buildExampleMap();

		if (paymentDueFlag) {
			appendPaymentDueFields(reportValueM);
		} else {
			appendNoPaymentDueFields(reportValueM);
		}

		return reportValueM;
	}

	/**
	 * Build an example parameter value map for the global portion of the PDF.
	 * 
	 * @return Map of report parameters.
	 */
	private Map<String, Object> buildSimpleMap() {

		final String siteNumber = "442";
		final String accountNumber = "4421234567890HCSNE";

		Map<String, Object> reportValueM = new HashMap<>();

		reportValueM.put("va", ClassLoader.getSystemResource("va.png"));

		reportValueM.put("SiteLocationName", "CHEYENNE VA MEDICAL CENTER");
		reportValueM.put("SiteAddress", "2360 EAST PERSHING BLVD.");
		reportValueM.put("SiteCityStateZip", "CHEYENNE, WY 82011");

		final ScanLine scanLine = new ScanLine(siteNumber, accountNumber, "352.50");
		reportValueM.put("MailingLabel", scanLine.getCalculatedScanLine());

		reportValueM.put("PatientName", "John Smith");

		// This is the patient address in the title band.
		// Jasper is goofy. Could not get a subreport to work for a dynamically
		// sized list.
		// The subreport would work but it would push down the following band
		// for no good reason.
		// Workaround is to populate up to six rows of address lines (last one
		// being the city, state zip) leaving any trailing ones blank.
		final String patientCityStateZip = "WASHINGTON DC 20002";

		final String patientAddress1 = "RR1 Box 7";
		final String patientAddress2 = patientCityStateZip;

		reportValueM.put("PatientAddress", patientAddress1 + "<br/>" + patientAddress2);

		reportValueM.put("QuestionsPhone", "1-866-682-XXXX");

		reportValueM.put("PayByPhone", "1-888-827-4817");
		reportValueM.put("PayHours", "8am-5pm");

		reportValueM.put("PaymentDate", "08/24/2015");

		reportValueM.put("AccountNumber", PdfPatientStatementFactoryService.formatAccountNumber(accountNumber));
		reportValueM.put("StatementDate", "08/27/2015");

		reportValueM.put("LocalMessage", "Local VA'S MESSAGE");

		return reportValueM;
	}

	/**
	 * Build an example parameter value map for the global portion of the PDF.
	 * 
	 * @return Map of report parameters.
	 */
	private Map<String, Object> buildExampleMap() {

		final String siteNumber = "442";
		final String accountNumber = "4421234567890HCSNE";
		final String otherNumber = "DD000000352504";
		final String separator1 = "**";
		final String separator2 = "***";

		Map<String, Object> reportValueM = new HashMap<>();

		reportValueM.put("va", ClassLoader.getSystemResource("va.png"));

		reportValueM.put("SiteLocationName", "CHEYENNE VA MEDICAL CENTER");
		reportValueM.put("SiteAddress", "2360 EAST PERSHING BLVD.");
		reportValueM.put("SiteCityStateZip", "CHEYENNE, WY 82011");

		reportValueM.put("MailingLabel", siteNumber + separator1 + accountNumber + separator2 + otherNumber);

		reportValueM.put("PatientName", "TSTENDRKM CHEN HCSNETTIRKM");

		// This is the patient address in the title band.
		// Jasper is goofy. Could not get a subreport to work for a dynamically
		// sized list.
		// The subreport would work but it would push down the following band
		// for no good reason.
		// Workaround is to populate up to six rows of address lines (last one
		// being the city, state zip) leaving any trailing ones blank.
		final String patientCityStateZip = "WASHINGTON DC 20002";

		final String patientAddress1 = "2 Massachusetts Ave NE";
		final String patientAddress2 = "222TestStreetAddress88Ave";
		final String patientAddress3 = "333TestStreetAddress88Ave";
		final String patientAddress4 = patientCityStateZip;

		reportValueM.put("PatientAddress",
				patientAddress1 + "<br/>" + patientAddress2 + "<br/>" + patientAddress3 + "<br/>" + patientAddress4);

		reportValueM.put("QuestionsPhone", "1-866-682-XXXX");

		reportValueM.put("PayByPhone", "1-888-827-4817");
		reportValueM.put("PayHours", "XXX XXX XXX XXXXX");

		reportValueM.put("PaymentDate", "08/24/2015");

		reportValueM.put("AccountNumber", accountNumber);
		reportValueM.put("StatementDate", "08/27/2015");

		reportValueM.put("LocalMessage", "Local VA'S MESSAGE");

		return reportValueM;
	}

	/**
	 * Append fields for a payment due example to the parameter value map.
	 * 
	 * @param parameterValueM
	 *            The updated parameter value map.
	 */
	private void appendPaymentDueFields(Map<String, Object> parameterValueM) {

		final String paymentDueDate = "09/19/2015";

		parameterValueM.put("PreviousBalance", "500.00");
		parameterValueM.put("PaymentsReceived", "219.00");
		parameterValueM.put("NewCharges", "138.96");

		parameterValueM.put("PaymentDueDate", paymentDueDate);
		parameterValueM.put("PaymentDueMessage",
				"TO AVOID LATE<br/>CHARGES PAY BALANCE<br/>BY " + paymentDueDate);

		parameterValueM.put("Balance", "419.96");
		parameterValueM.put("AmountDue", "419.96");
	}

	/**
	 * Append fields for a no payment due example to the parameter value map.
	 * 
	 * @param parameterValueM
	 *            The updated parameter value map.
	 */
	private void appendNoPaymentDueFields(Map<String, Object> parameterValueM) {

		final String paymentDueDate = "NO PAYMENT DUE";

		parameterValueM.put("PreviousBalance", "260.00");
		parameterValueM.put("PaymentsReceived", "518.96");
		parameterValueM.put("NewCharges", "138.96");

		parameterValueM.put("PaymentDueDate", paymentDueDate);
		parameterValueM.put("PaymentDueMessage", paymentDueDate);

		parameterValueM.put("Balance", "120.00CR");
		parameterValueM.put("AmountDue", "0.00");
	}

}
