package gov.va.cpss.jasper;

import static org.junit.Assume.assumeTrue;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.impl.CBSStmtDAOImpl;
import gov.va.cpss.model.cbs.CBSStmt;
import gov.va.cpss.service.StationInfoService;


/**
 * Tests for Generating Consolidated Patient Statement PDF using a
 * SendCBSWritePSRecordSource.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/cpss-batch.xml", "/cpss-email.xml" })
public class ConsolidatedPatientStatementPSRecordSourceTest {

	private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
	
	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;
	
	@Autowired
	private PdfPatientStatementFactoryService pdfPatientStatementFactoryService;
	
	private Connection jdbcConnection = null;
	
	private JdbcTemplate jdbcTemplate;

	/**
	 * @param dataSource
	 */
	@Autowired
	public void setDataSource(DataSource dataSource)
	{
		try
		{
			this.jdbcConnection = dataSource.getConnection();
			this.jdbcTemplate = new JdbcTemplate(dataSource);
		}
		catch (SQLException e)
		{
			// Auto-generated catch block
			e.printStackTrace();
			this.logger.info("SQL Exception in getting JDBC connection.");
		}
	}
	
		
	/**
	 * Only run these tests if property is set to run integration test.
	 */
	@Before
    public final void beforeTest() {
    	assumeTrue(runIntegrationTest);
    	executeTestData("sql/CpsPSRecordSourceTest-DeleteData.sql");
    }

	/**
	 * Tear down test data - delete from DB after tests.
	 */
	@After
	public void tearDown()
	{
		if (runIntegrationTest) {
			executeTestData("sql/CpsPSRecordSourceTest-DeleteData.sql");
		}
	}
	
	@Test
	public void test() throws Exception
	{
    	//Insert Test Data
    	executeTestData("sql/CpsPSRecordSourceTest01-InsertData.sql");
    	//Get Id of the cbsstmt of the inserted data 
    	final String sql = "SELECT * FROM CBSStmt WHERE accountid = (SELECT ID FROM CBSAccount WHERE ICN = 'ICN1234567890TEST')";
    	final List<CBSStmt> id = jdbcTemplate.query(sql, new CBSStmtDAOImpl.CBSStmtRowMapper());
    	
    	//run pdf generation on the inserted data
    	pdfPatientStatementFactoryService.generateStatementPdfFile(id.get(0).getId(), "OnlineCBSSPrototype.pdf");
	}
	@Test
	public void testLate() throws Exception
	{
    	//Insert Test Data
    	executeTestData("sql/CpsPSRecordSourceTest02-InsertData.sql");
    	//Get Id of the cbsstmt of the inserted data 
    	final String sql = "SELECT * FROM CBSStmt WHERE accountid = (SELECT ID FROM CBSAccount WHERE ICN = 'ICN1234567890LATE')";
    	final List<CBSStmt> id = jdbcTemplate.query(sql, new CBSStmtDAOImpl.CBSStmtRowMapper());
    	
    	//run pdf generation on the inserted data
    	pdfPatientStatementFactoryService.generateStatementPdfFile(id.get(0).getId(), "OnlineCbssLatePrototype.pdf");
	}
	// Execute test data SQL script file
	private void executeTestData(String sqlFile)
	{
		Resource sqlResource = new ClassPathResource(sqlFile);
		ScriptUtils.executeSqlScript(this.jdbcConnection, sqlResource);
	}
}