package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.ProcessStatusDAO;
import gov.va.cpss.dao.SiteBalRecDAO;
import gov.va.cpss.model.ProcessStatus;
import gov.va.cpss.model.bal.SiteBalRec;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit test for SiteBalRecDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public class SiteBalRecDAOImplTest {

	@Autowired
	private SiteBalRecDAO siteBalRecDao;
	
	@Autowired
	private ProcessStatusDAO processStatusDao;
	
	private List<SiteBalRec> siteBalRecL;
	
	@Before
	public final void beforeTest() {
		insertTestData();
	}
	
	@After
	public final void afterTest() {
		cleanupTestData();
	}
	
	@Test
	public final void testGetById() {
		final SiteBalRec siteBalRecExpected = siteBalRecL.get(0);
		
		final SiteBalRec siteBalRecRetrieved = siteBalRecDao.getById(siteBalRecExpected.getId());
		
		assertSiteBalRecEquals(siteBalRecExpected, siteBalRecRetrieved);
	}
	
	@Test
	public final void testUpdateResults() {
		final SiteBalRec siteBalRecOriginal = new SiteBalRec(0);
		siteBalRecOriginal.setFileName("fakefile.test");
		siteBalRecOriginal.setBatchRunId(1);
		siteBalRecOriginal.setTotNumFacility(1);
		siteBalRecOriginal.setTotNumPatient(1);
		siteBalRecOriginal.setProcessStatus(processStatusDao.getStatusFromEnum(ProcessStatus.Status.INITIAL));
		siteBalRecOriginal.setId(siteBalRecDao.save(siteBalRecOriginal));
		
		final SiteBalRec siteBalRecOriginalRetrieved = siteBalRecDao.getById(siteBalRecOriginal.getId());
		
		assertSiteBalRecEquals(siteBalRecOriginal, siteBalRecOriginalRetrieved);
		
		// Make updates
		siteBalRecOriginal.setProcessStatus(processStatusDao.getStatusFromEnum(ProcessStatus.Status.REPLACED));
		siteBalRecOriginal.setTotNumFacility(121);
		siteBalRecOriginal.setTotNumPatient(444);
		
		siteBalRecDao.updateResults(siteBalRecOriginal);
		
		// Verify updates
		final SiteBalRec siteBalRecUpdatedRetrieved = siteBalRecDao.getById(siteBalRecOriginal.getId());
		
		assertSiteBalRecEquals(siteBalRecOriginal, siteBalRecUpdatedRetrieved);
	}
	
	private final void insertTestData() {
		final SiteBalRec siteBalRec1 = new SiteBalRec(0);
		siteBalRec1.setFileName("fakefile.test");
		siteBalRec1.setBatchRunId(0);
		siteBalRec1.setTotNumFacility(1);
		siteBalRec1.setTotNumPatient(1);
		siteBalRec1.setProcessStatus(processStatusDao.getStatusFromEnum(ProcessStatus.Status.INITIAL));
		siteBalRec1.setId(siteBalRecDao.save(siteBalRec1));
		
		siteBalRecL = new ArrayList<SiteBalRec>();
		siteBalRecL.add(siteBalRec1);
	}
	
	private final void cleanupTestData() {
		siteBalRecL.forEach(siteBalRec -> siteBalRecDao.deleteById(siteBalRec.getId()));
	}
	
	private static final void assertSiteBalRecEquals(final SiteBalRec expected, final SiteBalRec retrieved) {
		assertEquals(expected.getBatchRunId(), retrieved.getBatchRunId());
		assertEquals(expected.getFileName(), retrieved.getFileName());
		assertEquals(expected.getTotNumFacility(), retrieved.getTotNumFacility());
		assertEquals(expected.getTotNumPatient(), retrieved.getTotNumPatient());
	}
}
