package gov.va.cpss.dao.impl;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.fps.PSDetails;
import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSReceived;
import gov.va.cpss.model.fps.PSSite;

/**
 * Unit testss for PSDetailsDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public final class PSDetailsDAOImplTest extends AbstractCbsDaoImplTest {
	
	@Test
	public final void testGetLastIndex() {
		final PSDetails psDetailsNew = cbsDaoImplUtils.createTestPSDetails(testPsPatientL.get(0));
		psDetailsNew.setId(cbsDaoImplUtils.savePSDetails(psDetailsNew));
		testPsDetailsL.add(psDetailsNew);
		
		assertEquals(psDetailsNew.getId(), (long)psDetailsDao.getLastIndex());
	}
	
	@Test
	public final void testGetAllByPSSiteID() {
		final List<PSDetails> psDetailsRetrievedL = psDetailsDao.getAllByPSSiteID(testPsSiteL.get(0));
		assertNotNull(psDetailsRetrievedL);
		assertEquals(testPsDetailsL.size(), psDetailsRetrievedL.size());
	}
	
	@Override
	protected void insertTestData() {
		final BatchRun batchRun = cbsDaoImplUtils.createTestBatchRun();
		batchRun.setId(batchRunDao.save(batchRun));
		testBatchRunL.add(batchRun);
		
		final PSReceived psReceived = cbsDaoImplUtils.createTestPSReceived(batchRun);
		psReceived.setId(psReceivedDao.save(psReceived));
		testPsReceivedL.add(psReceived);
		
		final PSSite psSite = cbsDaoImplUtils.createTestPSSite(psReceived);
		psSite.setId(psSiteDao.save(psSite));
		testPsSiteL.add(psSite);
		
		final PSPatient psPatient = cbsDaoImplUtils.createTestPSPatient(psSite);
		psPatient.setId(psPatientDao.save(psPatient));
		testPsPatientL.add(psPatient);
		
		final PSDetails psDetails1 = cbsDaoImplUtils.createTestPSDetails(psPatient);
		psDetails1.setId(cbsDaoImplUtils.savePSDetails(psDetails1));
		testPsDetailsL.add(psDetails1);
		
		final PSDetails psDetails2 = cbsDaoImplUtils.createTestPSDetails(psPatient);
		psDetails2.setId(cbsDaoImplUtils.savePSDetails(psDetails2));
		testPsDetailsL.add(psDetails2);
	}

}
