package gov.va.cpss.dao.impl;

import static org.junit.Assert.*;
import static org.junit.Assume.assumeTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.BatchSrcTypeDAO;
import gov.va.cpss.model.BatchSrcType;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit test for BatchSrcTypeDAOImpl
 * 
 * @author Andrew Vance
 */
public class BatchSrcTypeDAOImplTest {
	
	private static final int NUM_BATCH_SRC_TYPES = 2;
	
	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	@Autowired
	private BatchSrcTypeDAO batchSrcTypeDao;
	
	private List<BatchSrcType.SrcType> srcTypeL;
	
	@Before
	public final void beforeTest() {
		assumeTrue(runIntegrationTest);
		
		batchSrcTypeDao.initTypeMaps();
		buildSrcTypeL();
	}
	
	@Test
	public final void test() {
		final List<BatchSrcType> batchSrcTypeL = batchSrcTypeDao.batchSrcTypeList();
		assertNotNull(batchSrcTypeL);
		assertTrue(batchSrcTypeL.size() == NUM_BATCH_SRC_TYPES);
		for(BatchSrcType.SrcType srcType : srcTypeL) {
			
			boolean found = false;
			
			for(BatchSrcType batchSrcType : batchSrcTypeL) {
				if(batchSrcType.getName().equals(srcType.getName())) {
					found = true;
				}
			}
			
			assertTrue(found);
		}
	}
	
	private final void buildSrcTypeL() {
		srcTypeL = new ArrayList<BatchSrcType.SrcType>();
		srcTypeL.add(BatchSrcType.SrcType.CBS);
		srcTypeL.add(BatchSrcType.SrcType.APS);
	}
}
