package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.BatchRun;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml" })
/**
 * Unit test for BatchRunDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public class BatchRunDAOImplTest extends AbstractCbsDaoImplTest {

	@Test
	public final void testGetBadBatchRun() {
		final int badBatchJobId = 12345;

		final BatchRun badBatchRun = batchRunDao.getLastRunByBatchJobId(badBatchJobId);

		assertNull(badBatchRun);
	}

	@Test
	public final void testInsertUpdate() {
		final BatchRun batchRunExpected = testBatchRunL.get(0);

		final BatchRun retrievedBatchRun = batchRunDao.getLastRunByBatchJobId(batchRunExpected.getJobId());
		assertEquals(batchRunExpected.getId(), retrievedBatchRun.getId());
		assertEquals(batchRunExpected.getJobId(), retrievedBatchRun.getJobId());
		assertEquals(batchRunExpected.getStartDate(), retrievedBatchRun.getStartDate());
		assertEquals(batchRunExpected.getEndDate(), retrievedBatchRun.getEndDate());
		assertEquals(batchRunExpected.getMessage(), retrievedBatchRun.getMessage());

		final String updatedMessage = "updated message";
		batchRunExpected.setMessage(updatedMessage);

		batchRunDao.save(batchRunExpected);

		final BatchRun retrievedUpdatedBatchRun = batchRunDao.getLastRun();
		assertEquals(updatedMessage, retrievedUpdatedBatchRun.getMessage());
	}

	@Override
	protected void insertTestData() {
		final BatchRun batchRun = cbsDaoImplUtils.createTestBatchRun();
		batchRun.setId(batchRunDao.save(batchRun));
		testBatchRunL.add(batchRun);
	}
}
