package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.BatchJob;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/apps-dao-test-context.xml" })
/**
 * Unit test for BatchJobDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public final class BatchJobDAOImplTest extends AbstractCbsDaoImplTest {

	@Test
	public final void testUpdateGet() {
		final BatchJob testBatchJob = testBatchJobL.get(0);

		final String newName = "New Test Batch Job Name";
		final String newEmail = "newEmail@newEmail.test";
		final String newSchedule = "newSchedule";
		final int newTypeId = 2;

		testBatchJob.setName(newName);
		testBatchJob.setEmail(newEmail);
		testBatchJob.setSchedule(newSchedule);
		testBatchJob.setTypeId(newTypeId);

		batchJobDao.update(testBatchJob);

		final BatchJob retrievedBatchJob = batchJobDao.getBatchJob(testBatchJob.getId());

		assertNotNull(retrievedBatchJob);

		// Verify new values were changed
		assertEquals(newName, retrievedBatchJob.getName());
		assertEquals(newEmail, retrievedBatchJob.getEmail());
		assertEquals(newSchedule, retrievedBatchJob.getSchedule());
		assertEquals(newTypeId, retrievedBatchJob.getTypeId());

		// Verify other values are unchanged
		assertEquals(testBatchJob.getDescription(), retrievedBatchJob.getDescription());
		assertEquals(testBatchJob.getSourceType(), retrievedBatchJob.getSourceType());
	}

	@Test
	public final void testBatchList() {
		final List<BatchJob> cbssBatchList = batchJobDao.cbssBatchList();
		assertNotNull(cbssBatchList);
		final List<String> cbssBatchJobNameL = new ArrayList<String>();
		cbssBatchList.forEach(cbssBatchJob -> cbssBatchJobNameL.add(cbssBatchJob.getName()));
		assertTrue(cbssBatchJobNameL.contains("ProcessFPSDataJob"));
		assertTrue(cbssBatchJobNameL.contains("SendCBSJob"));
		assertTrue(cbssBatchJobNameL.contains("UpdatePrintAckJob"));
		assertTrue(cbssBatchJobNameL.contains("LoadBillDataJob"));
		assertTrue(cbssBatchJobNameL.contains("SendBillDataJob"));
		assertTrue(cbssBatchJobNameL.contains("UpdateICNJob"));

		final List<BatchJob> appsBatchList = batchJobDao.appsBatchList();
		assertNotNull(appsBatchList);
		final List<String> appsBatchJobNameL = new ArrayList<String>();
		appsBatchList.forEach(appsBatchJob -> appsBatchJobNameL.add(appsBatchJob.getName()));
		assertTrue(appsBatchJobNameL.contains("LoadAnnualVAMCPaymentDataJob"));
		assertTrue(appsBatchJobNameL.contains("GenerateAPPSDataJob"));
		assertTrue(appsBatchJobNameL.contains("SendAPPSAITCCCPCJob"));
		assertTrue(appsBatchJobNameL.contains("UpdateAPPSPrintAckJob"));

		final List<BatchJob> batchList = batchJobDao.batchList();
		assertNotNull(batchList);
		final List<String> batchJobNameL = new ArrayList<String>();
		batchList.forEach(batchJob -> batchJobNameL.add(batchJob.getName()));
		assertTrue(batchJobNameL.containsAll(appsBatchJobNameL));
		assertTrue(batchJobNameL.containsAll(cbssBatchJobNameL));
	}

	@Test
	public void testGetBatchJobByName() {
		final BatchJob expectedBatchJob = testBatchJobL.get(0);

		final BatchJob retrievedBatchJobByName = batchJobDao.getBatchJobByName(expectedBatchJob.getName());

		assertEquals(expectedBatchJob.getId(), retrievedBatchJobByName.getId());
	}

	@Test
	public void testGetBatchJobByNameAndSourceType() {
		final BatchJob expectedBatchJob = testBatchJobL.get(0);

		final BatchJob retrievedBatchJobBySourceType = batchJobDao
				.getBatchJobByNameAndSourceType(expectedBatchJob.getName(), expectedBatchJob.getSourceType());

		assertEquals(expectedBatchJob.getId(), retrievedBatchJobBySourceType.getId());
	}

	@Test
	public void testGetBatchJobBadId() {
		final int badId = 12345;

		final BatchJob badBatchJob = batchJobDao.getBatchJob(badId);

		assertNull(badBatchJob);
	}

	@Override
	protected void insertTestData() {
		final BatchJob testBatchJob1 = new BatchJob();
		testBatchJob1.setId(999);
		testBatchJob1.setName("Test Batch Job");
		testBatchJob1.setDescription("test description");
		testBatchJob1.setEmail("test@test.test");
		testBatchJob1.setSchedule("schedule string");
		testBatchJob1.setTypeId(1);
		testBatchJob1.setSourceType(1);

		testBatchJobL.add(testBatchJob1);

		testBatchJobL.forEach(testBatchJob -> {
			// TODO type_id and sourcetype could come from respective DAOs.
			// Andrew Vance 3/8/2017
			final String sql = "INSERT INTO BatchJob (id, name, description, email, schedule, type_id, sourcetype) "
					+ "VALUES (?, ?, ?, ?, ?, ?, ?)";

			jdbcTemplate.update(sql, testBatchJob.getId(), testBatchJob.getName(), testBatchJob.getDescription(),
					testBatchJob.getEmail(), testBatchJob.getSchedule(), testBatchJob.getTypeId(),
					testBatchJob.getSourceType());
		});

	}
}
