package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Calendar;
import java.util.Date;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.BatchConfig;
import gov.va.cpss.model.BatchJob;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/apps-dao-test-context.xml" })
/**
 * Unit test for BatchJobDAOImpl.
 *
 */
public final class BatchConfigDAOImplTest extends AbstractCbsDaoImplTest {

	@Test
	public final void testUpdateorInsert() {

		Calendar incrementOneDay = Calendar.getInstance();
		incrementOneDay.setTime(new Date());
		incrementOneDay.add(Calendar.DATE, 1);

		Calendar incrementTenDays = Calendar.getInstance();
		incrementTenDays.setTime(new Date());
		incrementTenDays.add(Calendar.DATE, 10);

		final BatchJob testBatchJob = new BatchJob();
		final int id = 9999;
		testBatchJob.setId(id);

		int batchJobId = testBatchJob.getId();
		Date rangeStart = new Date();
		Date rangeEnd = incrementOneDay.getTime();

		final BatchConfig testBatchConfig = new BatchConfig();
		testBatchConfig.setBatchJobId(testBatchJob.getId());
		testBatchConfig.setRangeStart(rangeStart);
		testBatchConfig.setRangeEnd(rangeEnd);

		testBatchJob.setBatchConfig(testBatchConfig);

		testBatchConfigL.add(testBatchConfig);

		batchConfigDao.updateOrInsert(testBatchJob);

		final BatchConfig retrievedBatchConfig = batchConfigDao.getBatchConfig(testBatchJob.getId());

		assertNotNull(retrievedBatchConfig);
		// Verify new values were changed
		assertEquals(batchJobId, retrievedBatchConfig.getBatchJobId());
		assertEquals(rangeStart.getTime(), retrievedBatchConfig.getRangeStart().getTime(), 1000);
		assertEquals(rangeEnd.getTime(), retrievedBatchConfig.getRangeEnd().getTime(), 1000);

		Date newRangeStart = incrementOneDay.getTime();
		Date newRangeEnd = incrementTenDays.getTime();

		testBatchJob.getBatchConfig().setRangeStart(newRangeStart);
		testBatchJob.getBatchConfig().setRangeEnd(newRangeEnd);

		batchConfigDao.updateOrInsert(testBatchJob);

		final BatchConfig newRetrievedBatchConfig = batchConfigDao.getBatchConfig(testBatchJob.getId());

		assertNotNull(newRetrievedBatchConfig);

		// Verify new values were changed
		assertEquals(batchJobId, newRetrievedBatchConfig.getBatchJobId());
		assertEquals(newRangeStart.getTime(), newRetrievedBatchConfig.getRangeStart().getTime(), 1000);
		assertEquals(newRangeEnd.getTime(), newRetrievedBatchConfig.getRangeEnd().getTime(), 1000);
	}

	@Override
	protected void insertTestData() {

	}
}
