package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.time.Instant;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSReceived;
import gov.va.cpss.model.apps.APSSite;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit tests for APSSiteDAOImpl
 * 
 * @author Andrew Vance
 *
 */
public final class APSSiteDAOImplTest extends AbstractApsDaoImplTest {
	@Test
	public final void test() {
		final APSSite apsSiteExpected = testApsSiteL.get(0);
		final long apsReceivedId = testApsReceivedL.get(0).getId();
		
		//getById
		final APSSite apsSiteRetrieved = apsSiteDao.getById(apsSiteExpected.getId());
		assertNotNull(apsSiteRetrieved);
		assertApsSiteEquals(apsSiteExpected, apsSiteRetrieved);
		
		//getAllByAPSReceivedId
		final List<APSSite> apsSiteRetrievedL = apsSiteDao.getAllByAPSReceivedId(apsReceivedId);
		assertNotNull(apsSiteRetrievedL);
		assertTrue(apsSiteRetrievedL.size() == 1);
		assertApsSiteEquals(apsSiteExpected, apsSiteRetrievedL.get(0));
		
		//getAllIdByAPSReceivedId
		final List<Long> apsSiteIdRetrievedL = apsSiteDao.getAllIdByAPSReceivedId(apsReceivedId);
		assertNotNull(apsSiteIdRetrievedL);
		assertTrue(apsSiteIdRetrievedL.size() == 1);
		assertTrue(apsSiteIdRetrievedL.contains(apsSiteExpected.getId()));
		
		//getPaymentReceivedSites
		final List<APSSite> apsSiteByPaymentL = apsSiteDao.getPaymentReceivedSites(2016, new java.sql.Date(Instant.EPOCH.toEpochMilli()));
		assertNotNull(apsSiteByPaymentL);
		assertTrue(apsSiteByPaymentL.size() > 0);
		assertTrue(apsSiteByPaymentL.stream().anyMatch(apsSite -> apsSite.getId() == apsSiteExpected.getId()));
		
		//getByPatients
		final List<APSSite> apsSiteByPatientL = apsSiteDao.getByPatients(testApsPatientL);
		assertNotNull(apsSiteByPatientL);
		assertTrue(apsSiteByPatientL.size() == 1);
		assertEquals(apsSiteExpected.getId(), apsSiteByPatientL.get(0).getId());
		
		//deleteByReceivedId
		assertNotNull(apsSiteDao.getById(apsSiteExpected.getId()));
		apsSiteDao.deleteByReceivedId(apsReceivedId);
		assertNull(apsSiteDao.getById(apsSiteExpected.getId()));
	}
	
	private static final void assertApsSiteEquals(final APSSite expected, final APSSite retrieved) {
		assertEquals(expected.getApsReceivedId(), retrieved.getApsReceivedId());
		assertEquals(expected.getFacilityNum(), retrieved.getFacilityNum());
		assertEquals(expected.getFacilityPhoneNum(), retrieved.getFacilityPhoneNum());
		assertEquals(expected.getProcessDate(), retrieved.getProcessDate());
		assertEquals(expected.getSeqNum(), retrieved.getSeqNum());
		assertEquals(expected.getStatementDateStr(), retrieved.getStatementDateStr());
		assertEquals(expected.getStatusId(), retrieved.getStatusId());
		assertEquals(expected.getTotalPatient(), retrieved.getTotalPatient());
		assertEquals(expected.getTotSeqNum(), retrieved.getTotSeqNum());
	}
	
	@Override
	protected final void insertTestData() {
		final APSReceived apsReceived = appsDaoImplUtils.createTestAPSReceived();
		apsReceived.setId(apsReceivedDao.save(apsReceived));
		testApsReceivedL.add(apsReceived);
		
		final APSSite apsSite = appsDaoImplUtils.createTestApsSite(apsReceived);
        apsSite.setId(apsSiteDao.save(apsSite));
        testApsSiteL.add(apsSite);
        
        final APSPatient apsPatient1 = appsDaoImplUtils.createTestApsPatient(apsSite);
        apsPatient1.setId(apsPatientDao.save(apsPatient1));
        testApsPatientL.add(apsPatient1);
	}
}
