package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.APSReceivedDAO;
import gov.va.cpss.dao.ProcessStatusDAO;
import gov.va.cpss.model.ProcessStatus;
import gov.va.cpss.model.apps.APSReceived;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit tests for APSReceivedDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public class APSReceivedDAOImplTest extends AbstractApsDaoImplTest {
	
	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;
	
	@Autowired
	private APPSDAOImplUtils appsDaoImplUtils;

	@Autowired
	private APSReceivedDAO apsReceivedDao;
	
	@Autowired
	private ProcessStatusDAO processStatusDao;
	
	private List<APSReceived> testApsReceivedL;
	
	private JdbcTemplate jdbcTemplate;

	@Autowired
	public void setDataSource(DataSource dataSource) {
		jdbcTemplate = new JdbcTemplate(dataSource);
	}
	
	@Test
	public final void testGetAPSReceivedIdListByStatus() { 
		final APSReceived apsReceived = testApsReceivedL.get(0);
		
		final List<Long> apsReceivedIdL = apsReceivedDao.getAPSReceivedIdListByStatus(
				processStatusDao.getStatusType(apsReceived.getStatusId()).getStatus());
		
		assertTrue(apsReceivedIdL.contains(apsReceived.getId()));
	}
	
	@Test
	public final void testUpdateResults() {
		final APSReceived apsReceived = testApsReceivedL.get(0);
		
		final APSReceived apsReceivedBefore = getApsReceived(apsReceived.getId());
		
		assertEquals(apsReceived.getStatusId(), apsReceivedBefore.getStatusId());
		assertEquals(apsReceived.getNumOfSite(), apsReceivedBefore.getNumOfSite());
		assertEquals(apsReceived.getNumOfPatient(), apsReceivedBefore.getNumOfPatient());
				
		final int newStatusId = processStatusDao.getStatusFromEnum(ProcessStatus.Status.SUCCESS);
		final int newNumSite = 1738;
		final int newNumPatient = 710;
		
		apsReceived.setStatusId(newStatusId);
		apsReceived.setNumOfSite(newNumSite);
		apsReceived.setNumOfPatient(newNumPatient);
		
		assertEquals(1, apsReceivedDao.updateResults(apsReceived));
		
		final APSReceived apsReceivedAfter = getApsReceived(apsReceived.getId());
		
		assertEquals(apsReceivedBefore.getId(), apsReceivedAfter.getId());
		assertEquals(apsReceived.getStatusId(), apsReceivedAfter.getStatusId());
		assertEquals(apsReceived.getNumOfSite(), apsReceivedAfter.getNumOfSite());
		assertEquals(apsReceived.getNumOfPatient(), apsReceivedAfter.getNumOfPatient());
		
	}

	@Override
	protected final void insertTestData() {
		testApsReceivedL = new ArrayList<APSReceived>();
		
		final APSReceived apsReceived = appsDaoImplUtils.createTestAPSReceived();	
		apsReceived.setId(apsReceivedDao.save(apsReceived));

        testApsReceivedL.add(apsReceived);
	}
	
	private final APSReceived getApsReceived(final long id) {
		final String sql = "SELECT * FROM " + APSReceivedDAOImpl.TABLE_NAME + " WHERE ID = " + id;
		
		final List<APSReceived> apsReceivedL = jdbcTemplate.query(sql, new RowMapper<APSReceived>(){

			@Override
			public APSReceived mapRow(ResultSet rs, int rowNum) throws SQLException {
				final APSReceived apsReceived = new APSReceived(rs.getInt("batchRunId"),
						rs.getInt("statusId"),
						rs.getDate("dateReceived"),
						rs.getString("filename"));
				apsReceived.setId(rs.getLong("id"));
				apsReceived.setNumOfPatient(rs.getLong("numOfPatient"));
				apsReceived.setNumOfSite(rs.getLong("numOfSite"));
				apsReceived.setBatchRunId(rs.getInt("batchRunId"));
				return apsReceived;
			}
		});
		
		return apsReceivedL.get(0) != null ? apsReceivedL.get(0) : null;
	}
}
