package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSReceived;
import gov.va.cpss.model.apps.APSSite;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/apps-dao-test-context.xml"})
/**
 * Unit tests for APSPatientDAOImpl
 * 
 * @author Andrew Vance
 *
 */
public final class APSPatientDAOImplTest extends AbstractApsDaoImplTest {
	@Test
	public final void testGetAllByAPSSite() {
		final List<APSPatient> patientBySiteL = apsPatientDao.getAllByAPSSite(testApsSiteL.get(0));
		assertNotNull(patientBySiteL);
		assertEquals(2, patientBySiteL.size());
		testApsPatientL.forEach(apsPatient -> {
			assertTrue(patientBySiteL.stream().mapToLong(APSPatient::getId).anyMatch(id -> id == apsPatient.getId()));
		});
	}
	
	@Test
	public final void testGetPatientsWithPaging() {
		final int pageSize = 1;
		
		final List<APSPatient> patientPagingL = apsPatientDao.getPatientsWithPaging(1, pageSize, 2016,
				processStatusDao.getStatusType(testApsReceivedL.get(0).getStatusId()).getStatus());
		assertNotNull(patientPagingL);
		assertEquals(pageSize, patientPagingL.size());
	}
	
	@Test
	public final void testSimpleGet() {
		final APSPatient apsPatientExpected = testApsPatientL.get(0);
		
		final APSPatient apsPatient = (APSPatient)apsPatientDao.select("where id = " + apsPatientExpected.getId(), "").get(0);
		assertNotNull(apsPatient);
		assertAPSPatientEquals(apsPatientExpected, apsPatient);
	}
	
	private static final void assertAPSPatientEquals(final APSPatient apsPatientExpected, final APSPatient apsPatientRetrieved) {
		assertEquals(apsPatientExpected.getId(), apsPatientRetrieved.getId());
		assertEquals(apsPatientExpected.getAccountNumber(), apsPatientRetrieved.getAccountNumber());
		assertEquals(apsPatientExpected.getAddress1(), apsPatientRetrieved.getAddress1());
		assertEquals(apsPatientExpected.getAddress2(), apsPatientRetrieved.getAddress2());
		assertEquals(apsPatientExpected.getAddress3(), apsPatientRetrieved.getAddress3());
		assertEquals(apsPatientExpected.getApsSite().getId(), apsPatientRetrieved.getApsSite().getId());
		assertEquals(apsPatientExpected.getArAddressFlg(), apsPatientRetrieved.getArAddressFlg());
		assertEquals(apsPatientExpected.getCity(), apsPatientRetrieved.getCity());
		assertEquals(apsPatientExpected.getCountry(), apsPatientRetrieved.getCountry());
		assertEquals(apsPatientExpected.getDfn(), apsPatientRetrieved.getDfn());
		assertEquals(apsPatientExpected.getFirstName(), apsPatientRetrieved.getFirstName());
		assertEquals(apsPatientExpected.getLastName(), apsPatientRetrieved.getLastName());
		assertEquals(apsPatientExpected.getMiddleName(), apsPatientRetrieved.getMiddleName());
		assertEquals(apsPatientExpected.getNumOfPD(), apsPatientRetrieved.getNumOfPD());
		assertEquals(apsPatientExpected.getState(), apsPatientRetrieved.getState());
		assertEquals(apsPatientExpected.getStatusId(), apsPatientRetrieved.getStatusId());
		assertEquals(apsPatientExpected.getTotalAmountReceived().toString(), apsPatientRetrieved.getTotalAmountReceived().toString());
		assertEquals(apsPatientExpected.getType(), apsPatientRetrieved.getType());
		assertEquals(apsPatientExpected.getZipCode(), apsPatientRetrieved.getZipCode());
	}
	
	protected final void insertTestData() {
		// Create APSReceived
		final APSReceived apsReceived = appsDaoImplUtils.createTestAPSReceived();	
		apsReceived.setId(apsReceivedDao.save(apsReceived));
		testApsReceivedL.add(apsReceived);
		
		// Create APSSite
		final APSSite apsSite = appsDaoImplUtils.createTestApsSite(apsReceived);		
        apsSite.setId(apsSiteDao.save(apsSite));   
        testApsSiteL.add(apsSite);
		
		// Create APSPatient
        final APSPatient apsPatient1 = appsDaoImplUtils.createTestApsPatient(apsSite);
        apsPatient1.setId(apsPatientDao.save(apsPatient1));
        testApsPatientL.add(apsPatient1);
        
        final APSPatient apsPatient2 = appsDaoImplUtils.createTestApsPatient(apsSite);
        apsPatient2.setIcn("testicn56234");
        apsPatient2.setDfn(19181712);
        apsPatient2.setAccountNumber("oldaccntnum44");
        apsPatient2.setId(apsPatientDao.save(apsPatient2));
        testApsPatientL.add(apsPatient2);
	}
}
