package gov.va.cpss.dao.impl;

import java.util.HashSet;
import java.util.Set;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * Wrapper for tests involving the APPS tables.
 * 
 * @author Andrew Vance
 */
public abstract class APPSDAOTestWrapper {
	
	protected Logger logger = Logger.getLogger(this.getClass().getName());
	
	private final Set<Long> apsStmtIdS = new HashSet<Long>();
	
	private final Set<Long> batchRunProcessIdS = new HashSet<Long>();
	
	private final Set<Long> accountIdS = new HashSet<Long>();

	public Logger getLogger() {
		return logger;
	}

	public void setLogger(Logger logger) {
		this.logger = logger;
	}

	public Set<Long> getAccountIdS() {
		return accountIdS;
	}

	//TODO javadoc
	public Set<Long> getApsStmtIdS() {
		return apsStmtIdS;
	}

	//TODO javadoc
	public Set<Long> getBatchRunProcessIdS() {
		return batchRunProcessIdS;
	}
	
	//TODO javadoc
	public void run(final JdbcTemplate jdbcTemplate) {
		try {
			test();
		} finally {
			for (Long apsStmtId : apsStmtIdS) {
				final int deleted = jdbcTemplate.update("DELETE FROM APSStmt WHERE id=" + apsStmtId);
			}
			for (Long batchRunProcessId : batchRunProcessIdS) {
				jdbcTemplate.update("DELETE FROM BatchRunProcess WHERE id=" + batchRunProcessId);
			}
		}
	}
	
	//TODO javadoc
	protected abstract void test();
}