/**This JS Page is for Scriplets on the Batch.JSP **/
function checkNullReturnBlank(item) {
	return item || '';
}

//Update Job Status Table
function updateJobStatusTableAjax() {
	$.ajax({
		url : 'batch/updateJobStatusTable',
		type : 'GET',
		dataType : 'json',
		success : function(data) {
			$.each(data,function(i, item) {
				if (item.run !== null) {
					$('tr#batch'+ item.job.id+ ' td.bStart').text(checkNullReturnBlank(item.run.serverStartDateString));
					$('tr#batch'+ item.job.id+ ' td.bEnd').text(checkNullReturnBlank(item.run.serverEndDateString));

					if(item.run.batchStatus.jobStatus === JobStatus.ERROR) {
						$('tr#batch'+ item.job.id+ ' a.hrefStatusClick').html(checkNullReturnBlank(item.run.batchStatus.description)
								+ '<img src="resources/notice.png" alt="Notice!" />').attr('aria-label', 'Complete Error Notification');
					} else {
						$('tr#batch'+ item.job.id+ ' a.hrefStatusClick').html(checkNullReturnBlank(item.run.batchStatus.description));
					}

					if (item.run.batchStatus.jobStatus === JobStatus.RUNNING) {
						$('tr#batch'+ item.job.id+ ' td.bActionClick').html('<span class="disabled-link">Run</span>');
					} else if ($('tr#batch'+ item.job.id+ ' td.bActionClick').children('a').length === 0) {
						var a = $('<a>');
						a.addClass('hrefActionClick');
						a.data('job-id', item.job.id);
						a.text('Run');
						$('tr#batch' + item.job.id+ ' td.bActionClick')
						.html(a);
					}
				}
			});
		},
		error : function() {
			// Do nothing
		}
	});
}

function setJobStatusRefreshInterval() {
	var intervalId = setInterval(updateJobStatusTableAjax, 1500) || 0;
}

// Fix that centers Bootstrap modal dialogs vertically on the screen.
function centerModalDialogsVertically() {
	function alignModal(){
		var modalDialog = $(this).find('.modal-dialog');
		/* Applying the top margin on modal dialog to align it vertically center */
		modalDialog.css('margin-top', Math.max(0, ($(window).height() - modalDialog.height()) / 2));
	}
	
	// Align modal when it is displayed
	$('.modal').on('shown.bs.modal', alignModal);
	// Align modal when user resizes the window
	$(window).on('resize', function(){
		$('.modal:visible').each(alignModal);
	}); 
}

function initializeBatchConfigDialogEvents() {
	$(document).on('click', '.dialog-config-save', function(){
		$('#batchConfigForm').submit();
	});
	$(document).on('click', 'input[name=typeId]', function(){
		// Disable the time picker if in manual mode
		$('#dateTimeScheduleInput').prop('disabled', this.value === BatchType.MANUAL);
		if (this.value === BatchType.MANUAL) {
			// If manual mode set value to empty
			$('#dateTimeScheduleInput').val('');
		} else {
			// If not manual and value is empty then provide a default
			$('#dateTimeScheduleInput').val(function(_, value) {
				return value || '23:00:00';
			});
		}
	});
	$('#dialog-config').on('show.bs.modal', function () {
		$('#dateTimeScheduleInput').datetimepicker({
			format : 'HH:mm:ss'
		});
		$('#dateTimeScheduleInput').blur();
	});
	$('#dialog-config').on('hidden.bs.modal', function () {
		$('#dateTimeScheduleInput').datetimepicker('destroy');
	});
}

function initializeBatchConfigDialogPopup() {
	$('.hrefConfigClick').click(function() {
		var jobId = $(this).data('job-id');

		$.ajax({
			url : 'batch/configDialog',
			type : 'get',
			data : {
				id : jobId,
			},
			success : function(data) {
				var success = $($.parseHTML(data)).filter('#batchConfigDialog');
				$('#dialog-config').html(success.html());
				$('#dialog-config').modal('show');
				$(':input:enabled:visible:first').focus();
				$('.modal-backdrop').removeClass('modal-backdrop');
				$('#batchConfigForm').validate({
					rules: {
						email: {
							required: true,
						},
						schedule: {
							required: true,
						},
						typeId: {
							required: true,
						},
					},
					errorPlacement: function(error, element) {
						if(element.attr('name') === 'typeId') {
							error.insertAfter($('#typeIdGroup'));
						} else {
							error.insertAfter(element);
						}
					},
					submitHandler: function(form) {
						form.submit();
						// Hide the modal dialog when submit is successful
						$('#batchConfigDialog').dialog('close');
					},
				});
			},
			error : function() {
				// Do nothing
			}
		});
	});
}

function initializeBatchRunDialogEvents() {
	$(document).on('click', '.dialog-run-continue', function(){
		$('#batchRunForm').submit();
	});
	$('#dialog-run').on('show.bs.modal', function () {
		// No action
	});
	$('#dialog-run').on('hidden.bs.modal', function () {
		// No action
	});
}

function initializeBatchRunDialogPopup() {
	$(document).on('click', '.hrefActionClick', function(){
		var jobId = $(this).data('job-id');

		$.ajax({
			url : 'batch/runDialog',
			type : 'get',
			data : {
				id : jobId,
			},
			success : function(data) {
				// If it is running the response form will not exist and so the dialog should not open.
				var formElement = $($.parseHTML(data)).filter('#batchRunDialog');
				if (formElement.length) {
					$('#dialog-run').html(formElement.html());
					$('#dialog-run').modal('show');
					$('#dialog-run-continue').addClass('enabled').attr("tabindex",0).focus();
					$('.modal-backdrop').removeClass('modal-backdrop');
				}
			},
			error : function() {
				alert('ERROR, can not pop up run dialog');
			}
		});
	});
}

$(function() {
	setJobStatusRefreshInterval();

	centerModalDialogsVertically();
	
	initializeBatchConfigDialogEvents();	
	initializeBatchConfigDialogPopup();
	
	initializeBatchRunDialogEvents();
	initializeBatchRunDialogPopup();
});
