/** This JS Page is for Scriplets on the APPS Batch.JSP * */
function checkNullReturnBlank(item) {
	return item || '';
}
//Update Job Status Table
function updateAppsJobStatusTableAjax() {
	$.ajax({
		url : 'appsBatch/updateAppsJobStatusTable',
		type : 'GET',
		dataType : 'json',
		success : function(data) {
			$.each(data,function(i, item) {
				if (item.run !== null) {
					$('tr#batch' + item.job.id + ' td.bStart')
						.text(checkNullReturnBlank(item.run.serverStartDateString));
					$('tr#batch' + item.job.id + ' td.bEnd')
						.text(checkNullReturnBlank(item.run.serverEndDateString));
					if(item.run.batchStatus.jobStatus === JobStatus.ERROR) {
						$('tr#batch' + item.job.id + ' a.hrefStatusClick')
							.html(checkNullReturnBlank(item.run.batchStatus.description) 
								+ '<img src="resources/notice.png" alt="Notice!" />')
							.attr('aria-label', 'Complete Error Notification');
					} else {
						$('tr#batch' + item.job.id + ' a.hrefStatusClick')
							.html(checkNullReturnBlank(item.run.batchStatus.description));
					}
					if (item.run.batchStatus.jobStatus === JobStatus.RUNNING) {
						$('tr#batch' + item.job.id + ' td.bActionClick')
							.html('<span class="disabled-link">Run</span>');
					} else if ($('tr#batch' + item.job.id + ' td.bActionClick').children('a').length === 0) {
						var a = $('<a>');
						a.addClass('hrefActionClick');
						a.data('job-id', item.job.id);
						a.text('Run');
						$('tr#batch' + item.job.id + ' td.bActionClick').html(a);
					}
				}
			});
		},
		error : function() {
			//TODO: handle error
		}
	});
}

function setJobStatusRefreshInterval() {
	var intervalId = setInterval(updateAppsJobStatusTableAjax, 1500) || 0;
}

//Fix that centers Bootstrap modal dialogs vertically on the screen.
function centerModalDialogsVertically() {
	function alignModal() {
		var modalDialog = $(this).find('.modal-dialog');
		/* Applying the top margin on modal dialog to align it vertically center */
		modalDialog.css('margin-top', Math.max(0, ($(window).height() - modalDialog.height()) / 2));
	}
	
	// Align modal when it is displayed
	$('.modal').on('shown.bs.modal', alignModal);
	// Align modal when user resizes the window
	$(window).on('resize', function() {
		$('.modal:visible').each(alignModal);
	}); 
}

function initializeAppsBatchConfigDialogEvents() {
	$(document).on('click', '.dialog-config-save', function(){
		$('#appsBatchConfigForm').submit();
	});
	
	var elementsToDisableForManual = [
		'#dateTimeScheduleInput',
		'#rangeStartInput',
		'#rangeEndInput',
	];
	
	$(document).on('click', 'input[name=typeId]', function(batchType) {
		// Disable the date and time pickers if in manual mode
		if (this.value === BatchType.MANUAL) {
			elementsToDisableForManual.forEach(function(element) {
				$(element).prop('disabled', true);
				$(element).val('');
			});
		} else {
			// Enable elements for when non-manual schedule type is selected
			elementsToDisableForManual.forEach(function(element) {
				$(element).prop('disabled', false);
			});
			
			// Provide default values
			$('#dateTimeScheduleInput').val(function(_, value) {
				return value || '23:00:00';
			});
			
			$('#rangeStartInput').val(function(_, value) {
				// TODO: A better default than '' could be provided. (new Date(Date.now()).toLocaleDateString()) 
				// gives the proper date string but leads to unexpected behavior with Jquery Validation -AV 4/14/2017
				return value || '';
			});
			
			$('#rangeEndInput').val(function(_, value) {
				return value || '';
			});
		}
	});
	
	// Initialize datetime-/datepickers on show
	$('#dialog-config').on('show.bs.modal', function () {
		$('#dateTimeScheduleInput').datetimepicker({
			format: 'HH:mm:ss',
		});
		$('#dateTimeScheduleInput').blur();
		
		$('#rangeStartInput').datepicker({
			dateFormat: 'yy-mm-dd',
			changeMonth: true,
			changeYear: true,
			constrainInput: true,
		});
		$('#rangeStartInput').blur();
		
		$('#rangeEndInput').datepicker({
			dateFormat: 'yy-mm-dd',
			changeMonth: true,
			changeYear: true,
			constrainInput: true,
		});
		$('#rangeEndInput').blur();
		
		if($('input[name=typeId]:checked').attr('value')===BatchType.MANUAL){
			$('#rangeStartInput').val('');
			$('#rangeEndInput').val('');
		}
	});
	
	// Destroy datetime-/datepickers on hide
	$('#dialog-config').on('hidden.bs.modal', function () {
		$('#dateTimeScheduleInput').datetimepicker('destroy');
		$('#rangeStartInput').datepicker('destroy');
		$('#rangeEndInput').datepicker('destroy');
	});
}

function initializeAppsBatchConfigDialogPopup() {
	// Add date range to validation rules
	jQuery.validator.addMethod('isAfterStartDate', function() {
		return Date.parse($('#rangeStartInput').val()) < Date.parse($('#rangeEndInput').val());
	});
	
	$('.hrefConfigClick').click(function() {
		var jobId = $(this).data('job-id');

		$.ajax({
			url : 'appsBatch/appsConfigDialog',
			type : 'get',
			data : {
				id : jobId,
			},
			success : function(data) {
				var success = $($.parseHTML(data)).filter('#appsBatchConfigDialog');
				$('#dialog-config').html(success.html());
				$('#dialog-config').modal('show');
				$(':input:enabled:visible:first').focus();
				$('.modal-backdrop').removeClass('modal-backdrop');
				$('#appsBatchConfigForm').validate({
					rules: {
						'email': {
							required: true,
						},
						'batchConfig.rangeStart': {
							required: true,
						},
						'batchConfig.rangeEnd': {
							required: true,
							isAfterStartDate: true,
						},
						'schedule': {
							required: true,
						},
						'typeId': {
							required: true,
						},
					},
					messages: {
						'batchConfig.rangeEnd': {
							isAfterStartDate: 'End date must be after start date.',
						},
					},
					errorPlacement: function(error, element) {
						if(element.attr('name') === 'typeId') {
							error.insertAfter($('#typeIdGroup'));
						} else {
							error.insertAfter(element);
						}
					},
					submitHandler: function(form) {
						form.submit();
						// Hide the modal dialog when submit is successful
						$('#appsBatchConfigDialog').dialog('close');
					}
				});
			},
			error : function() {
				alert('ERROR, can not pop up config dialog');
			}
		});

	});
}

function initializeAppsBatchRunDialogEvents() {
	$(document).on('click', '.dialog-run-continue', function() {
		$('#appsBatchRunForm').submit();
	});
	$('#dialog-run').on('show.bs.modal', function() {
		// No action
	});
	$('#dialog-run').on('hidden.bs.modal', function() {
		// No action
	});
}

function initializeAppsBatchRunDialogPopup() {
	$(document).on('click', '.hrefActionClick', function() {
		var jobId = $(this).data('job-id');
		
		$.ajax({
			url : 'appsBatch/appsRunDialog',
			type : 'get',
			data : {
				id : jobId,
			},
			success : function(data) {
				// If it is running the response form will not exist and so the dialog should not open.
				var formElement = $($.parseHTML(data)).filter('#appsBatchRunDialog');
				if (formElement.length) {
					$('#dialog-run').html(formElement.html());
					$('#dialog-run').modal('show');
					$('#dialog-run-continue').addClass('enabled').attr("tabindex",0).focus();
					$('.modal-backdrop').removeClass('modal-backdrop');
				}
			},
			error : function() {
				alert('ERROR, can not pop up run dialog');
			}
		});
	});
}

// Page startup events
$(function() {
	setJobStatusRefreshInterval();
	
	centerModalDialogsVertically();
	
	initializeAppsBatchConfigDialogEvents();
	initializeAppsBatchConfigDialogPopup();
	
	initializeAppsBatchRunDialogEvents();
	initializeAppsBatchRunDialogPopup();
});
