<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ page session="false"%>
<!DOCTYPE html>
<html>
<head>
<title>CBSS Batch Job</title>

</head>
<body>

	<script src="bootstrap/js/bootstrap.js"></script>
	<script src="datetimepicker/js/bootstrap-datetimepicker.min.js"></script>

	<div id="batchConfigDialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-body">
					<form:form id="batchConfigForm" action="batch/saveBatch"
						method="post" modelAttribute="batchJob" class="form-horizontal">
						<form:hidden path="id" />
						<form:hidden path="name" />
						<form:hidden path="description" />

						<div class="form-group container radio-button-container">
							<div class="row-centered">
								<div class="row">
									<div role="radiogroup" aria-labelledby="batchRadioButtonGroup" id="typeIdGroup">
										<span id="batchRadioButtonGroup" class="panel-title" style="text-align: center">
											<strong><c:out value="${batchJob.description}" /></strong>
										</span>
										<br>
										<br>
										<c:forEach var="rt" items="${rts}">
											<div id="form-group${rt.id}"
												class="col-1 inline-block radio-padding">
												<c:if test="${rt.name != 'Specified' && rt.name != 'Scheduled'}">
													<form:radiobutton  path="typeId" value="${rt.id}"
														label="${rt.name}" />
												</c:if>
											</div>
										</c:forEach>
									</div>
								</div>
							</div>
						</div>

						<div class="form-group">
							<label for="dateTimeScheduleInput" class="col-sm-3 control-label">Time:</label>
							<div class="date form_datetime col-sm-7">
								<form:input type="text" class="form-control" path="schedule"
									id="dateTimeScheduleInput" placeholder="Time"
									disabled="${batchJob.typeId == 2}" />
								<form:errors path="schedule" cssClass="error" />
							</div>
						</div>

						<div class="form-group">
							<label for="emailAddressInput" class="col-sm-3 control-label">Email:</label>
							<div class="col-sm-7">
								<form:input  type="email" class="form-control" path="email"
									id="emailAddressInput" placeholder="Email" />
								<form:errors path="email" cssClass="error" />
							</div>
						</div>
					</form:form>

				</div>

				<div class="modal-footer">
					<div>
						<button  id="dialog-config-save" type="button"
							class="btn btn-primary dialog-config-save" style="width: 80px;">Save</button>
						<button  type="button" class="btn btn-primary" data-dismiss="modal"
							style="width: 80px;">Cancel</button>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>
</html>
