<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ page session="false"%>
<!DOCTYPE html>
<html>
<head>
<title>Apps Batch Job</title>

</head>
<body>

	<script src="bootstrap/js/bootstrap.min.js"></script>
	<script src="datetimepicker/js/bootstrap-datetimepicker.min.js"></script>

	<div id="appsBatchConfigDialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-body appsBatchConfigDialog">
					<form:form id="appsBatchConfigForm" action="appsBatch/saveBatch"
						method="post" modelAttribute="batchJob" class="form-horizontal">
						<form:hidden path="id" />
						<form:hidden path="name" />
						<form:hidden path="description" />

						<h2 class="panel-title" style="text-align: center" >
							<strong>${batchJob.description}</strong>
						</h2>
						<br>
						
						<div class="form-group container radio-button-container">
							<div class="row-centered">
								<div class="row">
									<div role="radiogroup" aria-labelledby="appsBatchConfigForm" id="typeIdGroup">
										<c:forEach var="rt" items="${rts}">
											<div id="form-group${rt.id}" class="col-1 inline-block">
												<c:if test="${rt.name != 'Daily' && rt.name != 'Specified'}">
													<form:radiobutton  path="typeId" value="${rt.id}" label="${rt.name}"  />
												</c:if>
											</div>
										</c:forEach>
									</div>
									
								</div>
							</div>
						</div>

						<div class="form-group">
							<label for="rangeStartInput" class="col-sm-3 control-label">Start
								Date:</label>
							<div class="date form_datetime col-sm-7">
								<form:input  type="date" class="form-control" path="batchConfig.rangeStart"
									id="rangeStartInput" placeholder="Date"
									disabled="${batchJob.typeId == 2}" />
								<form:errors path="batchConfig.rangeStart" cssClass="error" />
							</div>
						</div>
						<br>
						<div class="form-group">
							<label for="rangeEndInput" class="col-sm-3 control-label">End
								Date:</label>
							<div class="date form_datetime col-sm-7">
								<form:input  type="date" class="form-control" path="batchConfig.rangeEnd"
									id="rangeEndInput" placeholder="Date"
									disabled="${batchJob.typeId == 2}" />
								<form:errors path="batchConfig.rangeEnd" cssClass="error" />
							</div>
						</div>
						<br>

						<div class="form-group">
							<label for="dateTimeScheduleInput" class="col-sm-3 control-label">Time:</label>
							<div class="date form_datetime col-sm-7">
								<form:input  type="text" class="form-control" path="schedule"
									id="dateTimeScheduleInput" placeholder="Time"
									disabled="${batchJob.typeId == 2}" />
								<form:errors path="schedule" cssClass="error" />
							</div>
						</div>
						<br>
						
						<div class="form-group">
							<label for="emailAddressInput" class="col-sm-3 control-label">Email:</label>
							<div class="col-sm-7">
								<form:input  type="text" class="form-control" path="email"
									id="emailAddressInput" placeholder="Email" />
								<form:errors path="email" cssClass="error"  />
							</div>
						</div>
					</form:form>
				</div>

				<div class="modal-footer">
					<div>
						<button id="dialog-config-save" type="button" 
							class="btn btn-primary dialog-config-save" style="width: 80px;">Save</button>
						<button  type="button" class="btn btn-primary" data-dismiss="modal"
							style="width: 80px;">Cancel</button>
					</div>
				</div>
			</div>
		</div>
	</div>

</body>
</html>
